/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler;

import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.LongAccumulator;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pinot.$internal.com.google.common.util.concurrent.ListenableFutureTask;
import org.apache.pinot.$internal.com.google.common.util.concurrent.MoreExecutors;
import org.apache.pinot.$internal.org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.OutOfCapacityException;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerPriorityQueue;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerQueryContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.QueryExecutorService;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PriorityScheduler
extends QueryScheduler {
    private static Logger LOGGER = LoggerFactory.getLogger(PriorityScheduler.class);
    protected final SchedulerPriorityQueue queryQueue;
    @VisibleForTesting
    protected final Semaphore runningQueriesSemaphore;
    private final int numRunners;
    @VisibleForTesting
    Thread scheduler;

    public PriorityScheduler(@Nonnull ResourceManager resourceManager, @Nonnull QueryExecutor queryExecutor, @Nonnull SchedulerPriorityQueue queue, @Nonnull ServerMetrics metrics, @Nonnull LongAccumulator latestQueryTime) {
        super(queryExecutor, resourceManager, metrics, latestQueryTime);
        Preconditions.checkNotNull(queue);
        this.queryQueue = queue;
        this.numRunners = resourceManager.getNumQueryRunnerThreads();
        this.runningQueriesSemaphore = new Semaphore(this.numRunners);
    }

    @Override
    @Nonnull
    public ListenableFuture<byte[]> submit(@Nonnull ServerQueryRequest queryRequest) {
        if (!this.isRunning) {
            return this.immediateErrorResponse(queryRequest, QueryException.SERVER_SCHEDULER_DOWN_ERROR);
        }
        queryRequest.getTimerContext().startNewPhaseTimer(ServerQueryPhase.SCHEDULER_WAIT);
        SchedulerQueryContext schedQueryContext = new SchedulerQueryContext(queryRequest);
        try {
            this.queryQueue.put(schedQueryContext);
        }
        catch (OutOfCapacityException e) {
            LOGGER.error("Out of capacity for table {}, message: {}", (Object)queryRequest.getTableNameWithType(), (Object)e.getMessage());
            return this.immediateErrorResponse(queryRequest, QueryException.SERVER_OUT_OF_CAPACITY_ERROR);
        }
        this.serverMetrics.addMeteredTableValue(queryRequest.getTableNameWithType(), ServerMeter.QUERIES, 1L);
        return schedQueryContext.getResultFuture();
    }

    @Override
    public void start() {
        super.start();
        this.scheduler = new Thread(new Runnable(){

            @Override
            public void run() {
                while (PriorityScheduler.this.isRunning) {
                    try {
                        PriorityScheduler.this.runningQueriesSemaphore.acquire();
                    }
                    catch (InterruptedException e) {
                        if (!PriorityScheduler.this.isRunning) {
                            LOGGER.info("Shutting down scheduler");
                            break;
                        }
                        LOGGER.error("Interrupt while acquiring semaphore. Exiting.", (Throwable)e);
                        break;
                    }
                    try {
                        final SchedulerQueryContext request = PriorityScheduler.this.queryQueue.take();
                        if (request == null) continue;
                        ServerQueryRequest queryRequest = request.getQueryRequest();
                        final QueryExecutorService executor = PriorityScheduler.this.resourceManager.getExecutorService(queryRequest, request.getSchedulerGroup());
                        ListenableFutureTask<byte[]> queryFutureTask = PriorityScheduler.this.createQueryFutureTask(queryRequest, executor);
                        queryFutureTask.addListener(new Runnable(){

                            @Override
                            public void run() {
                                executor.releaseWorkers();
                                request.getSchedulerGroup().endQuery();
                                PriorityScheduler.this.runningQueriesSemaphore.release();
                                PriorityScheduler.this.checkStopResourceManager();
                                if (!PriorityScheduler.this.isRunning && PriorityScheduler.this.runningQueriesSemaphore.availablePermits() == PriorityScheduler.this.numRunners) {
                                    PriorityScheduler.this.resourceManager.stop();
                                }
                            }
                        }, MoreExecutors.directExecutor());
                        request.setResultFuture(queryFutureTask);
                        request.getSchedulerGroup().startQuery();
                        queryRequest.getTimerContext().getPhaseTimer(ServerQueryPhase.SCHEDULER_WAIT).stopAndRecord();
                        PriorityScheduler.this.resourceManager.getQueryRunners().submit(queryFutureTask);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Error in scheduler thread. This is indicative of a bug. Please report this. Server will continue with errors", t);
                    }
                }
                if (PriorityScheduler.this.isRunning) {
                    throw new RuntimeException("FATAL: Scheduler thread is quitting.....something went horribly wrong.....!!!");
                }
                PriorityScheduler.this.failAllPendingQueries();
            }
        });
        this.scheduler.setName("scheduler");
        this.scheduler.setPriority(10);
        this.scheduler.setDaemon(true);
        this.scheduler.start();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.scheduler != null) {
            this.scheduler.interrupt();
        }
    }

    private synchronized void failAllPendingQueries() {
        List<SchedulerQueryContext> pending = this.queryQueue.drain();
        for (SchedulerQueryContext queryContext : pending) {
            queryContext.setResultFuture(this.immediateErrorResponse(queryContext.getQueryRequest(), QueryException.SERVER_SCHEDULER_DOWN_ERROR));
        }
    }

    private void checkStopResourceManager() {
        if (!this.isRunning && this.runningQueriesSemaphore.availablePermits() == this.numRunners) {
            this.resourceManager.stop();
        }
    }
}

