/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.fcfs;

import java.util.concurrent.atomic.LongAccumulator;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.MultiLevelPriorityQueue;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.PriorityScheduler;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroupFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerPriorityQueue;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.TableBasedGroupMapper;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.fcfs.FCFSSchedulerGroup;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.PolicyBasedResourceManager;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedFCFSScheduler
extends PriorityScheduler {
    private static Logger LOGGER = LoggerFactory.getLogger(BoundedFCFSScheduler.class);

    public static BoundedFCFSScheduler create(@Nonnull Configuration config, @Nonnull QueryExecutor queryExecutor, @Nonnull ServerMetrics serverMetrics, @Nonnull LongAccumulator latestQueryTime) {
        PolicyBasedResourceManager rm = new PolicyBasedResourceManager(config);
        SchedulerGroupFactory groupFactory = new SchedulerGroupFactory(){

            @Override
            public SchedulerGroup create(Configuration config, String groupName) {
                return new FCFSSchedulerGroup(groupName);
            }
        };
        MultiLevelPriorityQueue queue = new MultiLevelPriorityQueue(config, rm, groupFactory, new TableBasedGroupMapper());
        return new BoundedFCFSScheduler(rm, queryExecutor, queue, serverMetrics, latestQueryTime);
    }

    private BoundedFCFSScheduler(@Nonnull ResourceManager resourceManager, @Nonnull QueryExecutor queryExecutor, @Nonnull SchedulerPriorityQueue queue, @Nonnull ServerMetrics metrics, @Nonnull LongAccumulator latestQueryTime) {
        super(resourceManager, queryExecutor, queue, metrics, latestQueryTime);
    }

    @Override
    public String name() {
        return "BoundedFCFSScheduler";
    }
}

