/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.fcfs;

import java.util.concurrent.atomic.LongAccumulator;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pinot.$internal.com.google.common.util.concurrent.ListenableFutureTask;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.QueryExecutorService;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.UnboundedResourceManager;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;

public class FCFSQueryScheduler
extends QueryScheduler {
    public FCFSQueryScheduler(@Nonnull Configuration config, @Nonnull QueryExecutor queryExecutor, @Nonnull ServerMetrics serverMetrics, @Nonnull LongAccumulator latestQueryTime) {
        super(queryExecutor, new UnboundedResourceManager(config), serverMetrics, latestQueryTime);
    }

    @Override
    @Nonnull
    public ListenableFuture<byte[]> submit(@Nonnull ServerQueryRequest queryRequest) {
        if (!this.isRunning) {
            return this.immediateErrorResponse(queryRequest, QueryException.SERVER_SCHEDULER_DOWN_ERROR);
        }
        queryRequest.getTimerContext().startNewPhaseTimer(ServerQueryPhase.SCHEDULER_WAIT);
        QueryExecutorService queryExecutorService = this.resourceManager.getExecutorService(queryRequest, null);
        ListenableFutureTask<byte[]> queryTask = this.createQueryFutureTask(queryRequest, queryExecutorService);
        this.resourceManager.getQueryRunners().submit(queryTask);
        return queryTask;
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public String name() {
        return "fcfs";
    }
}

