/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.tokenbucket;

import java.util.concurrent.atomic.LongAccumulator;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.MultiLevelPriorityQueue;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.PriorityScheduler;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.SchedulerGroupFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.TableBasedGroupMapper;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.PolicyBasedResourceManager;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.$internal.org.apache.pinot.core.query.scheduler.tokenbucket.TokenSchedulerGroup;
import org.apache.pinot.common.metrics.ServerMetrics;

public class TokenPriorityScheduler
extends PriorityScheduler {
    public static final String TOKENS_PER_MS_KEY = "tokens_per_ms";
    public static final String TOKEN_LIFETIME_MS_KEY = "token_lifetime_ms";
    private static final int DEFAULT_TOKEN_LIFETIME_MS = 100;

    public static TokenPriorityScheduler create(@Nonnull Configuration config, @Nonnull QueryExecutor queryExecutor, @Nonnull ServerMetrics metrics, @Nonnull LongAccumulator latestQueryTime) {
        final PolicyBasedResourceManager rm = new PolicyBasedResourceManager(config);
        SchedulerGroupFactory groupFactory = new SchedulerGroupFactory(){

            @Override
            public SchedulerGroup create(Configuration config, String groupName) {
                int maxTokensPerMs = rm.getNumQueryRunnerThreads() + rm.getNumQueryWorkerThreads();
                int tokensPerMs = config.getInt(TokenPriorityScheduler.TOKENS_PER_MS_KEY, maxTokensPerMs);
                int tokenLifetimeMs = config.getInt(TokenPriorityScheduler.TOKEN_LIFETIME_MS_KEY, 100);
                return new TokenSchedulerGroup(groupName, tokensPerMs, tokenLifetimeMs);
            }
        };
        MultiLevelPriorityQueue queue = new MultiLevelPriorityQueue(config, rm, groupFactory, new TableBasedGroupMapper());
        return new TokenPriorityScheduler((ResourceManager)rm, queryExecutor, queue, metrics, latestQueryTime);
    }

    private TokenPriorityScheduler(@Nonnull ResourceManager resourceManager, @Nonnull QueryExecutor queryExecutor, @Nonnull MultiLevelPriorityQueue queue, @Nonnull ServerMetrics metrics, @Nonnull LongAccumulator latestQueryTime) {
        super(resourceManager, queryExecutor, queue, metrics, latestQueryTime);
    }

    @Override
    public String name() {
        return "TokenBucket";
    }
}

