/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.selection;

import java.io.Serializable;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.DoubleArraySelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.DoubleSelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.FloatArraySelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.FloatSelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.IntArraySelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.IntSelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.LongArraySelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.LongSelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.SelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.SelectionSingleValueColumnWithDictIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.StringArraySelectionColumnIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.StringSelectionColumnIterator;
import org.apache.pinot.common.utils.DataSchema;

public class SelectionFetcher {
    private final int _numColumns;
    private final SelectionColumnIterator[] _selectionColumnIterators;

    public SelectionFetcher(Block[] blocks, DataSchema dataSchema) {
        this._numColumns = blocks.length;
        this._selectionColumnIterators = new SelectionColumnIterator[this._numColumns];
        block15: for (int i = 0; i < this._numColumns; ++i) {
            Block block = blocks[i];
            DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
            if (block.getMetadata().hasDictionary()) {
                switch (columnDataType) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: 
                    case BYTES: {
                        this._selectionColumnIterators[i] = new SelectionSingleValueColumnWithDictIterator(block);
                        continue block15;
                    }
                    case INT_ARRAY: {
                        this._selectionColumnIterators[i] = new IntArraySelectionColumnIterator(block);
                        continue block15;
                    }
                    case FLOAT_ARRAY: {
                        this._selectionColumnIterators[i] = new FloatArraySelectionColumnIterator(block);
                        continue block15;
                    }
                    case LONG_ARRAY: {
                        this._selectionColumnIterators[i] = new LongArraySelectionColumnIterator(block);
                        continue block15;
                    }
                    case DOUBLE_ARRAY: {
                        this._selectionColumnIterators[i] = new DoubleArraySelectionColumnIterator(block);
                        continue block15;
                    }
                    case STRING_ARRAY: {
                        this._selectionColumnIterators[i] = new StringArraySelectionColumnIterator(block);
                        continue block15;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            switch (columnDataType) {
                case INT: {
                    this._selectionColumnIterators[i] = new IntSelectionColumnIterator(block);
                    continue block15;
                }
                case LONG: {
                    this._selectionColumnIterators[i] = new LongSelectionColumnIterator(block);
                    continue block15;
                }
                case FLOAT: {
                    this._selectionColumnIterators[i] = new FloatSelectionColumnIterator(block);
                    continue block15;
                }
                case DOUBLE: {
                    this._selectionColumnIterators[i] = new DoubleSelectionColumnIterator(block);
                    continue block15;
                }
                case STRING: 
                case BYTES: {
                    this._selectionColumnIterators[i] = new StringSelectionColumnIterator(block);
                    continue block15;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    public Serializable[] getRow(int docId) {
        Serializable[] row = new Serializable[this._numColumns];
        for (int i = 0; i < this._numColumns; ++i) {
            row[i] = this._selectionColumnIterators[i].getValue(docId);
        }
        return row;
    }
}

