/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.selection.comparator;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.comparator.DocIdDoubleValComparator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.comparator.DocIdFloatValComparator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.comparator.DocIdIntValComparator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.comparator.DocIdLongValComparator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.comparator.IDocIdValComparator;
import org.apache.pinot.common.request.SelectionSort;

public final class CompositeDocIdValComparator
implements Comparator<Integer> {
    private final List<SelectionSort> sortSequence;
    private final Block[] blocks;
    IDocIdValComparator[] docIdValComparators;
    boolean[] eligibleToCompare;

    public CompositeDocIdValComparator(List<SelectionSort> sortSequence, Block[] blocks) {
        this.sortSequence = sortSequence;
        this.blocks = blocks;
        this.docIdValComparators = new IDocIdValComparator[blocks.length];
        this.eligibleToCompare = new boolean[blocks.length];
        Arrays.fill(this.eligibleToCompare, true);
        block6: for (int i = 0; i < sortSequence.size(); ++i) {
            if (!blocks[i].getMetadata().isSingleValue()) {
                this.eligibleToCompare[i] = false;
                continue;
            }
            if (blocks[i].getMetadata().hasDictionary()) {
                this.docIdValComparators[i] = new DocIdIntValComparator(blocks[i], sortSequence.get(i).isIsAsc());
                continue;
            }
            switch (blocks[i].getMetadata().getDataType()) {
                case INT: {
                    this.docIdValComparators[i] = new DocIdIntValComparator(blocks[i], sortSequence.get(i).isIsAsc());
                    continue block6;
                }
                case LONG: {
                    this.docIdValComparators[i] = new DocIdLongValComparator(blocks[i], sortSequence.get(i).isIsAsc());
                    continue block6;
                }
                case FLOAT: {
                    this.docIdValComparators[i] = new DocIdFloatValComparator(blocks[i], sortSequence.get(i).isIsAsc());
                    continue block6;
                }
                case DOUBLE: {
                    this.docIdValComparators[i] = new DocIdDoubleValComparator(blocks[i], sortSequence.get(i).isIsAsc());
                    continue block6;
                }
                default: {
                    this.eligibleToCompare[i] = false;
                }
            }
        }
    }

    @Override
    public int compare(Integer docId1, Integer docId2) {
        int ret = 0;
        for (int i = 0; i < this.sortSequence.size(); ++i) {
            if (!this.eligibleToCompare[i] || (ret = this.docIdValComparators[i].compare(docId1, docId2)) == 0) continue;
            return ret;
        }
        return ret;
    }
}

