/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator;

import com.clearspring.analytics.util.Preconditions;
import java.io.Serializable;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockSingleValIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.query.selection.iterator.SelectionColumnIterator;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.primitive.ByteArray;

public class StringSelectionColumnIterator
implements SelectionColumnIterator {
    private final FieldSpec.DataType _dataType;
    protected BlockSingleValIterator bvIter;

    public StringSelectionColumnIterator(Block block) {
        this._dataType = block.getMetadata().getDataType();
        Preconditions.checkArgument((this._dataType.equals((Object)FieldSpec.DataType.STRING) || this._dataType.equals((Object)FieldSpec.DataType.BYTES) ? 1 : 0) != 0, (String)("Illegal data type for StringSelectionColumnIterator: " + (Object)((Object)this._dataType)), (Object[])new Object[0]);
        this.bvIter = (BlockSingleValIterator)block.getBlockValueSet().iterator();
    }

    @Override
    public Serializable getValue(int docId) {
        this.bvIter.skipTo(docId);
        if (this._dataType.equals((Object)FieldSpec.DataType.BYTES)) {
            byte[] bytes = this.bvIter.nextBytesVal();
            return ByteArray.toHexString(bytes);
        }
        return this.bvIter.nextStringVal();
    }
}

