/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter;

import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.common.data.Schema;

public class RealtimeSegmentRecordReader
implements RecordReader {
    private final MutableSegmentImpl _realtimeSegment;
    private final int _numDocs;
    private final Schema _schema;
    private final int[] _sortedDocIdIterationOrder;
    private int _nextDocId = 0;

    public RealtimeSegmentRecordReader(MutableSegmentImpl realtimeSegment, Schema schema) {
        this._realtimeSegment = realtimeSegment;
        this._numDocs = realtimeSegment.getNumDocsIndexed();
        this._schema = schema;
        this._sortedDocIdIterationOrder = null;
    }

    public RealtimeSegmentRecordReader(MutableSegmentImpl realtimeSegment, Schema schema, String sortedColumn) {
        this._realtimeSegment = realtimeSegment;
        this._numDocs = realtimeSegment.getNumDocsIndexed();
        this._schema = schema;
        this._sortedDocIdIterationOrder = realtimeSegment.getSortedDocIdIterationOrderWithSortedColumn(sortedColumn);
    }

    public int[] getSortedDocIdIterationOrder() {
        return this._sortedDocIdIterationOrder;
    }

    @Override
    public boolean hasNext() {
        return this._nextDocId < this._numDocs;
    }

    @Override
    public GenericRow next() {
        return this.next(new GenericRow());
    }

    @Override
    public GenericRow next(GenericRow reuse) {
        if (this._sortedDocIdIterationOrder == null) {
            return this._realtimeSegment.getRecord(this._nextDocId++, reuse);
        }
        return this._realtimeSegment.getRecord(this._sortedDocIdIterationOrder[this._nextDocId++], reuse);
    }

    @Override
    public void rewind() {
        this._nextDocId = 0;
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public void close() {
    }
}

