/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.stats;

import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockMultiValIterator;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunctionFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.SingleValueBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.MutableDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.data.source.ColumnDataSource;
import org.apache.pinot.common.config.ColumnPartitionConfig;
import org.apache.pinot.common.data.FieldSpec;

public class RealtimeColumnStatistics
implements ColumnStatistics {
    private final ColumnDataSource _dataSource;
    private final int[] _sortedDocIdIterationOrder;
    private final MutableDictionary _dictionaryReader;
    private final Block _block;
    private PartitionFunction _partitionFunction;
    private int _numPartitions;
    private Set<Integer> _partitions;

    public RealtimeColumnStatistics(ColumnDataSource dataSource, int[] sortedDocIdIterationOrder, ColumnPartitionConfig columnPartitionConfig) {
        this._dataSource = dataSource;
        this._sortedDocIdIterationOrder = sortedDocIdIterationOrder;
        this._dictionaryReader = (MutableDictionary)dataSource.getDictionary();
        this._block = dataSource.nextBlock();
        if (columnPartitionConfig != null) {
            String functionName = columnPartitionConfig.getFunctionName();
            this._numPartitions = columnPartitionConfig.getNumPartitions();
            PartitionFunction partitionFunction = this._partitionFunction = functionName != null ? PartitionFunctionFactory.getPartitionFunction(functionName, this._numPartitions) : null;
            if (this._partitionFunction != null) {
                this._partitions = new HashSet<Integer>();
                int length = this._dictionaryReader.length();
                for (int i = 0; i < length; ++i) {
                    this._partitions.add(this._partitionFunction.getPartition(this._dictionaryReader.get(i)));
                }
            }
        }
    }

    @Override
    public Object getMinValue() {
        return this._dictionaryReader.getMinVal();
    }

    @Override
    public Object getMaxValue() {
        return this._dictionaryReader.getMaxVal();
    }

    @Override
    public Object getUniqueValuesSet() {
        return this._dictionaryReader.getSortedValues();
    }

    @Override
    public int getCardinality() {
        return this._dictionaryReader.length();
    }

    @Override
    public int getLengthOfShortestElement() {
        int minStringLength;
        block3: {
            int length;
            FieldSpec.DataType dataType;
            block2: {
                minStringLength = Integer.MAX_VALUE;
                dataType = this._dataSource.getDataSourceMetadata().getDataType();
                length = this._dictionaryReader.length();
                if (!dataType.equals((Object)FieldSpec.DataType.STRING)) break block2;
                for (int i = 0; i < length; ++i) {
                    minStringLength = Math.min(this._dictionaryReader.getStringValue(i).length(), minStringLength);
                }
                break block3;
            }
            if (!dataType.equals((Object)FieldSpec.DataType.BYTES)) break block3;
            for (int i = 0; i < length; ++i) {
                minStringLength = Math.min(this._dictionaryReader.getBytesValue(i).length, minStringLength);
            }
        }
        return minStringLength;
    }

    @Override
    public int getLengthOfLargestElement() {
        int maximumStringLength;
        block3: {
            int length;
            FieldSpec.DataType dataType;
            block2: {
                maximumStringLength = 0;
                dataType = this._dataSource.getDataSourceMetadata().getDataType();
                length = this._dictionaryReader.length();
                if (!dataType.equals((Object)FieldSpec.DataType.STRING)) break block2;
                for (int i = 0; i < length; ++i) {
                    maximumStringLength = Math.max(this._dictionaryReader.getStringValue(i).length(), maximumStringLength);
                }
                break block3;
            }
            if (!dataType.equals((Object)FieldSpec.DataType.BYTES)) break block3;
            for (int i = 0; i < length; ++i) {
                maximumStringLength = Math.max(this._dictionaryReader.getBytesValue(i).length, maximumStringLength);
            }
        }
        return maximumStringLength;
    }

    @Override
    public boolean isSorted() {
        if (!this._block.getMetadata().isSingleValue()) {
            return false;
        }
        int blockLength = this._block.getMetadata().getLength();
        if (blockLength <= 1 || this.getCardinality() <= 1) {
            return true;
        }
        SingleColumnSingleValueReader singleValueReader = ((SingleValueBlock)this._block).getReader();
        int docIdIndex = this._sortedDocIdIterationOrder != null ? this._sortedDocIdIterationOrder[0] : 0;
        int dictionaryId = singleValueReader.getInt(docIdIndex);
        Comparable previousValue = (Comparable)this._dictionaryReader.get(dictionaryId);
        for (int i = 1; i < blockLength; ++i) {
            docIdIndex = this._sortedDocIdIterationOrder != null ? this._sortedDocIdIterationOrder[i] : i;
            dictionaryId = singleValueReader.getInt(docIdIndex);
            Comparable currentValue = (Comparable)this._dictionaryReader.get(dictionaryId);
            if (0 < previousValue.compareTo(currentValue)) {
                return false;
            }
            previousValue = currentValue;
        }
        return true;
    }

    @Override
    public int getTotalNumberOfEntries() {
        int multivalueEntryCount = 0;
        if (!this._block.getMetadata().isSingleValue()) {
            int[] dictionaryIds = new int[this.getMaxNumberOfMultiValues()];
            BlockMultiValIterator valIterator = (BlockMultiValIterator)this._block.getBlockValueSet().iterator();
            while (valIterator.hasNext()) {
                multivalueEntryCount += valIterator.nextIntVal(dictionaryIds);
            }
        }
        return multivalueEntryCount;
    }

    @Override
    public int getMaxNumberOfMultiValues() {
        return this._block.getMetadata().getMaxNumberOfMultiValues();
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public PartitionFunction getPartitionFunction() {
        return this._partitionFunction;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    @Override
    public Set<Integer> getPartitions() {
        return this._partitions;
    }
}

