/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.stats;

import java.util.Set;
import org.apache.pinot.$internal.org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.data.source.ColumnDataSource;

public class RealtimeNoDictionaryColStatistics
implements ColumnStatistics {
    final BlockValSet _blockValSet;
    final int _numDocIds;
    final String _operatorName;

    public RealtimeNoDictionaryColStatistics(ColumnDataSource dataSource) {
        this._operatorName = dataSource.getOperatorName();
        Object block = dataSource.nextBlock();
        this._numDocIds = block.getMetadata().getEndDocId() + 1;
        this._blockValSet = block.getBlockValueSet();
    }

    @Override
    public Object getMinValue() {
        throw new RuntimeException("Cannot get min value for no dictionary column " + this._operatorName);
    }

    @Override
    public Object getMaxValue() {
        throw new RuntimeException("Cannot get max value for no dictionary column " + this._operatorName);
    }

    @Override
    public Object getUniqueValuesSet() {
        return null;
    }

    @Override
    public int getCardinality() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getLengthOfShortestElement() {
        return this.lengthOfDataType();
    }

    @Override
    public int getLengthOfLargestElement() {
        return this.lengthOfDataType();
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public int getTotalNumberOfEntries() {
        return this._numDocIds;
    }

    @Override
    public int getMaxNumberOfMultiValues() {
        return 1;
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public PartitionFunction getPartitionFunction() {
        return null;
    }

    @Override
    public int getNumPartitions() {
        return 0;
    }

    @Override
    public Set<Integer> getPartitions() {
        return null;
    }

    private int lengthOfDataType() {
        switch (this._blockValSet.getValueType()) {
            case INT: {
                return 4;
            }
            case LONG: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
        }
        throw new UnsupportedOperationException();
    }
}

