/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.RealtimeSegmentRecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.stats.RealtimeColumnStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.converter.stats.RealtimeNoDictionaryColStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentPreIndexStatsContainer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.data.source.ColumnDataSource;
import org.apache.pinot.common.config.SegmentPartitionConfig;

public class RealtimeSegmentStatsContainer
implements SegmentPreIndexStatsContainer {
    private final MutableSegmentImpl _realtimeSegment;
    private final RealtimeSegmentRecordReader _realtimeSegmentRecordReader;
    private final Map<String, ColumnStatistics> _columnStatisticsMap = new HashMap<String, ColumnStatistics>();

    public RealtimeSegmentStatsContainer(MutableSegmentImpl realtimeSegment, RealtimeSegmentRecordReader realtimeSegmentRecordReader) {
        this._realtimeSegment = realtimeSegment;
        this._realtimeSegmentRecordReader = realtimeSegmentRecordReader;
        SegmentPartitionConfig segmentPartitionConfig = this._realtimeSegment.getSegmentPartitionConfig();
        for (String columnName : realtimeSegment.getPhysicalColumnNames()) {
            ColumnDataSource dataSource = realtimeSegment.getDataSource(columnName);
            if (dataSource.getDataSourceMetadata().hasDictionary()) {
                this._columnStatisticsMap.put(columnName, new RealtimeColumnStatistics(realtimeSegment.getDataSource(columnName), this._realtimeSegmentRecordReader.getSortedDocIdIterationOrder(), segmentPartitionConfig == null ? null : segmentPartitionConfig.getColumnPartitionMap().get(columnName)));
                continue;
            }
            this._columnStatisticsMap.put(columnName, new RealtimeNoDictionaryColStatistics(dataSource));
        }
    }

    @Override
    public ColumnStatistics getColumnProfileFor(String column) throws Exception {
        return this._columnStatisticsMap.get(column);
    }

    @Override
    public int getRawDocCount() {
        return this._realtimeSegment.getNumDocsIndexed();
    }

    @Override
    public int getAggregatedDocCount() {
        return 0;
    }

    @Override
    public int getTotalDocCount() {
        return this.getRawDocCount();
    }
}

