/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl;

import java.util.Set;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.common.config.SegmentPartitionConfig;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;

public class RealtimeSegmentConfig {
    private final String _segmentName;
    private final String _streamName;
    private final Schema _schema;
    private final int _capacity;
    private final int _avgNumMultiValues;
    private final Set<String> _noDictionaryColumns;
    private final Set<String> _invertedIndexColumns;
    private final RealtimeSegmentZKMetadata _realtimeSegmentZKMetadata;
    private final boolean _offHeap;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final RealtimeSegmentStatsHistory _statsHistory;
    private final SegmentPartitionConfig _segmentPartitionConfig;
    private final boolean _aggregateMetrics;

    private RealtimeSegmentConfig(String segmentName, String streamName, Schema schema, int capacity, int avgNumMultiValues, Set<String> noDictionaryColumns, Set<String> invertedIndexColumns, RealtimeSegmentZKMetadata realtimeSegmentZKMetadata, boolean offHeap, PinotDataBufferMemoryManager memoryManager, RealtimeSegmentStatsHistory statsHistory, SegmentPartitionConfig segmentPartitionConfig, boolean aggregateMetrics) {
        this._segmentName = segmentName;
        this._streamName = streamName;
        this._schema = schema;
        this._capacity = capacity;
        this._avgNumMultiValues = avgNumMultiValues;
        this._noDictionaryColumns = noDictionaryColumns;
        this._invertedIndexColumns = invertedIndexColumns;
        this._realtimeSegmentZKMetadata = realtimeSegmentZKMetadata;
        this._offHeap = offHeap;
        this._memoryManager = memoryManager;
        this._statsHistory = statsHistory;
        this._segmentPartitionConfig = segmentPartitionConfig;
        this._aggregateMetrics = aggregateMetrics;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public String getStreamName() {
        return this._streamName;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public int getAvgNumMultiValues() {
        return this._avgNumMultiValues;
    }

    public Set<String> getNoDictionaryColumns() {
        return this._noDictionaryColumns;
    }

    public Set<String> getInvertedIndexColumns() {
        return this._invertedIndexColumns;
    }

    public RealtimeSegmentZKMetadata getRealtimeSegmentZKMetadata() {
        return this._realtimeSegmentZKMetadata;
    }

    public boolean isOffHeap() {
        return this._offHeap;
    }

    public PinotDataBufferMemoryManager getMemoryManager() {
        return this._memoryManager;
    }

    public RealtimeSegmentStatsHistory getStatsHistory() {
        return this._statsHistory;
    }

    public SegmentPartitionConfig getSegmentPartitionConfig() {
        return this._segmentPartitionConfig;
    }

    public boolean aggregateMetrics() {
        return this._aggregateMetrics;
    }

    public static class Builder {
        private String _segmentName;
        private String _streamName;
        private Schema _schema;
        private int _capacity;
        private int _avgNumMultiValues;
        private Set<String> _noDictionaryColumns;
        private Set<String> _invertedIndexColumns;
        private RealtimeSegmentZKMetadata _realtimeSegmentZKMetadata;
        private boolean _offHeap;
        private PinotDataBufferMemoryManager _memoryManager;
        private RealtimeSegmentStatsHistory _statsHistory;
        private SegmentPartitionConfig _segmentPartitionConfig;
        private boolean _aggregateMetrics = false;

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder setStreamName(String streamName) {
            this._streamName = streamName;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this._schema = schema;
            return this;
        }

        public Builder setCapacity(int capacity) {
            this._capacity = capacity;
            return this;
        }

        public Builder setAvgNumMultiValues(int avgNumMultiValues) {
            this._avgNumMultiValues = avgNumMultiValues;
            return this;
        }

        public Builder setNoDictionaryColumns(Set<String> noDictionaryColumns) {
            this._noDictionaryColumns = noDictionaryColumns;
            return this;
        }

        public Builder setInvertedIndexColumns(Set<String> invertedIndexColumns) {
            this._invertedIndexColumns = invertedIndexColumns;
            return this;
        }

        public Builder setRealtimeSegmentZKMetadata(RealtimeSegmentZKMetadata realtimeSegmentZKMetadata) {
            this._realtimeSegmentZKMetadata = realtimeSegmentZKMetadata;
            return this;
        }

        public Builder setOffHeap(boolean offHeap) {
            this._offHeap = offHeap;
            return this;
        }

        public Builder setMemoryManager(PinotDataBufferMemoryManager memoryManager) {
            this._memoryManager = memoryManager;
            return this;
        }

        public Builder setStatsHistory(RealtimeSegmentStatsHistory statsHistory) {
            this._statsHistory = statsHistory;
            return this;
        }

        public Builder setSegmentPartitionConfig(SegmentPartitionConfig segmentPartitionConfig) {
            this._segmentPartitionConfig = segmentPartitionConfig;
            return this;
        }

        public Builder setAggregateMetrics(boolean aggregateMetrics) {
            this._aggregateMetrics = aggregateMetrics;
            return this;
        }

        public RealtimeSegmentConfig build() {
            return new RealtimeSegmentConfig(this._segmentName, this._streamName, this._schema, this._capacity, this._avgNumMultiValues, this._noDictionaryColumns, this._invertedIndexColumns, this._realtimeSegmentZKMetadata, this._offHeap, this._memoryManager, this._statsHistory, this._segmentPartitionConfig, this._aggregateMetrics);
        }
    }
}

