/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.MutableOffHeapByteArrayStore;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.common.utils.primitive.ByteArray;

public class BytesOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private final MutableOffHeapByteArrayStore _byteStore;
    private ByteArray _min = null;
    private ByteArray _max = null;

    public BytesOffHeapMutableDictionary(int estimatedCardinality, int maxOverflowHashSize, PinotDataBufferMemoryManager memoryManager, String allocationContext, int avgLength) {
        super(estimatedCardinality, maxOverflowHashSize, memoryManager, allocationContext);
        this._byteStore = new MutableOffHeapByteArrayStore(memoryManager, allocationContext, estimatedCardinality, avgLength);
    }

    @Override
    public int indexOf(Object rawValue) {
        assert (rawValue instanceof byte[]);
        byte[] bytes = (byte[])rawValue;
        return this.getDictId(new ByteArray(bytes), bytes);
    }

    public byte[] get(int dictId) {
        return this._byteStore.get(dictId);
    }

    @Override
    public byte[] getBytesValue(int dictId) {
        return this.get(dictId);
    }

    @Override
    public void doClose() throws IOException {
        this._byteStore.close();
    }

    @Override
    protected void setRawValueAt(int dictId, Object rawValue, byte[] serializedValue) {
        this._byteStore.add(serializedValue);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        assert (rawValue instanceof byte[]);
        byte[] bytes = (byte[])rawValue;
        ByteArray byteArray = new ByteArray(bytes);
        this.indexValue(byteArray, bytes);
        this.updateMinMax(byteArray);
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        throw new UnsupportedOperationException("In-range not supported for Bytes data type.");
    }

    @Override
    @Nonnull
    public Object getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public Object getMaxVal() {
        return this._max;
    }

    @Nonnull
    public ByteArray[] getSortedValues() {
        int numValues = this.length();
        Object[] sortedValues = new ByteArray[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = this.getInternal(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    private ByteArray getInternal(int dictId) {
        return new ByteArray(this._byteStore.get(dictId));
    }

    @Override
    protected boolean equalsValueAt(int dictId, Object value, byte[] serializedValue) {
        return this._byteStore.equalsValueAt(serializedValue, dictId);
    }

    private void updateMinMax(ByteArray value) {
        if (this._min == null) {
            this._min = value;
            this._max = value;
        } else if (value.compareTo(this._min) < 0) {
            this._min = value;
        } else if (value.compareTo(this._max) > 0) {
            this._max = value;
        }
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return super.getTotalOffHeapMemUsed() + this._byteStore.getTotalOffHeapMemUsed();
    }

    @Override
    public int getAvgValueSize() {
        return (int)this._byteStore.getAvgValueSize();
    }
}

