/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOnHeapMutableDictionary;
import org.apache.pinot.common.utils.primitive.ByteArray;

public class BytesOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private ByteArray _min = null;
    private ByteArray _max = null;

    @Override
    public int indexOf(Object rawValue) {
        assert (rawValue instanceof byte[]);
        return this.getDictId(new ByteArray((byte[])rawValue));
    }

    public byte[] get(int dictId) {
        return ((ByteArray)super.get(dictId)).getBytes();
    }

    @Override
    public byte[] getBytesValue(int dictId) {
        return this.get(dictId);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        assert (rawValue instanceof byte[]);
        ByteArray byteArray = new ByteArray((byte[])rawValue);
        this.indexValue(byteArray);
        this.updateMinMax(byteArray);
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        throw new UnsupportedOperationException("In-range not supported for Bytes data type.");
    }

    @Override
    @Nonnull
    public ByteArray getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public ByteArray getMaxVal() {
        return this._max;
    }

    @Nonnull
    public ByteArray[] getSortedValues() {
        int numValues = this.length();
        Object[] sortedValues = new ByteArray[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = (ByteArray)super.get(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    private void updateMinMax(ByteArray value) {
        if (this._min == null) {
            this._min = value;
            this._max = value;
        } else {
            if (value.compareTo(this._min) < 0) {
                this._min = value;
            }
            if (value.compareTo(this._max) > 0) {
                this._max = value;
            }
        }
    }
}

