/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.impl.FixedByteSingleColumnSingleValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOffHeapMutableDictionary;

public class DoubleOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private double _min = Double.MAX_VALUE;
    private double _max = Double.MIN_VALUE;
    private final FixedByteSingleColumnSingleValueReaderWriter _dictIdToValue;

    public DoubleOffHeapMutableDictionary(int estimatedCardinality, int maxOverflowSize, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        super(estimatedCardinality, maxOverflowSize, memoryManager, allocationContext);
        int initialEntryCount = this.nearestPowerOf2(estimatedCardinality);
        this._dictIdToValue = new FixedByteSingleColumnSingleValueReaderWriter(initialEntryCount, 8, memoryManager, allocationContext);
    }

    @Override
    public Object get(int dictionaryId) {
        return this._dictIdToValue.getDouble(dictionaryId);
    }

    @Override
    public int indexOf(Object rawValue) {
        if (rawValue instanceof String) {
            return this.getDictId(Double.valueOf((String)rawValue), null);
        }
        return this.getDictId(rawValue, null);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof Double) {
            this.indexValue(rawValue, null);
            this.updateMinMax((Double)rawValue);
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                this.indexValue(value, null);
                this.updateMinMax((Double)value);
            }
        }
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        double lowerDouble = Double.parseDouble(lower);
        double upperDouble = Double.parseDouble(upper);
        double valueToCompare = (Double)this.get(dictIdToCompare);
        if (includeLower ? valueToCompare < lowerDouble : valueToCompare <= lowerDouble) {
            return false;
        }
        return !(includeUpper ? valueToCompare > upperDouble : valueToCompare >= upperDouble);
    }

    @Override
    @Nonnull
    public Double getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public Double getMaxVal() {
        return this._max;
    }

    @Nonnull
    public double[] getSortedValues() {
        int numValues = this.length();
        double[] sortedValues = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = (Double)this.get(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public int getAvgValueSize() {
        return 8;
    }

    @Override
    protected void setRawValueAt(int dictId, Object value, byte[] serializedValue) {
        this._dictIdToValue.setDouble(dictId, (Double)value);
    }

    @Override
    public int getIntValue(int dictId) {
        return ((Double)this.get(dictId)).intValue();
    }

    @Override
    public long getLongValue(int dictId) {
        return ((Double)this.get(dictId)).longValue();
    }

    @Override
    public float getFloatValue(int dictId) {
        return ((Double)this.get(dictId)).floatValue();
    }

    @Override
    public double getDoubleValue(int dictId) {
        return (Double)this.get(dictId);
    }

    @Override
    public void doClose() throws IOException {
        this._dictIdToValue.close();
    }

    private void updateMinMax(double value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return super.getTotalOffHeapMemUsed() + (long)(8 * this.length());
    }
}

