/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.impl.FixedByteSingleColumnSingleValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOffHeapMutableDictionary;

public class FloatOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private float _min = Float.MAX_VALUE;
    private float _max = Float.MIN_VALUE;
    private final FixedByteSingleColumnSingleValueReaderWriter _dictIdToValue;

    public FloatOffHeapMutableDictionary(int estimatedCardinality, int maxOverflowSize, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        super(estimatedCardinality, maxOverflowSize, memoryManager, allocationContext);
        int initialEntryCount = this.nearestPowerOf2(estimatedCardinality);
        this._dictIdToValue = new FixedByteSingleColumnSingleValueReaderWriter(initialEntryCount, 4, memoryManager, allocationContext);
    }

    @Override
    public Object get(int dictionaryId) {
        return Float.valueOf(this._dictIdToValue.getFloat(dictionaryId));
    }

    @Override
    public int indexOf(Object rawValue) {
        if (rawValue instanceof String) {
            return this.getDictId(Float.valueOf((String)rawValue), null);
        }
        return this.getDictId(rawValue, null);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof Float) {
            this.indexValue(rawValue, null);
            this.updateMinMax(((Float)rawValue).floatValue());
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                this.indexValue(value, null);
                this.updateMinMax(((Float)value).floatValue());
            }
        }
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        float lowerFloat = Float.parseFloat(lower);
        float upperFloat = Float.parseFloat(upper);
        float valueToCompare = ((Float)this.get(dictIdToCompare)).floatValue();
        if (includeLower ? valueToCompare < lowerFloat : valueToCompare <= lowerFloat) {
            return false;
        }
        return !(includeUpper ? valueToCompare > upperFloat : valueToCompare >= upperFloat);
    }

    @Override
    @Nonnull
    public Float getMinVal() {
        return Float.valueOf(this._min);
    }

    @Override
    @Nonnull
    public Float getMaxVal() {
        return Float.valueOf(this._max);
    }

    @Nonnull
    public float[] getSortedValues() {
        int numValues = this.length();
        float[] sortedValues = new float[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = ((Float)this.get(i)).floatValue();
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public int getAvgValueSize() {
        return 4;
    }

    @Override
    protected void setRawValueAt(int dictId, Object value, byte[] serializedValue) {
        this._dictIdToValue.setFloat(dictId, ((Float)value).floatValue());
    }

    @Override
    public int getIntValue(int dictId) {
        return ((Float)this.get(dictId)).intValue();
    }

    @Override
    public long getLongValue(int dictId) {
        return ((Float)this.get(dictId)).longValue();
    }

    @Override
    public float getFloatValue(int dictId) {
        return ((Float)this.get(dictId)).floatValue();
    }

    @Override
    public double getDoubleValue(int dictId) {
        return ((Float)this.get(dictId)).doubleValue();
    }

    @Override
    public void doClose() throws IOException {
        this._dictIdToValue.close();
    }

    private void updateMinMax(float value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return super.getTotalOffHeapMemUsed() + (long)(4 * this.length());
    }
}

