/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOnHeapMutableDictionary;

public class FloatOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private float _min = Float.MAX_VALUE;
    private float _max = Float.MIN_VALUE;

    @Override
    public int indexOf(Object rawValue) {
        if (rawValue instanceof String) {
            return this.getDictId(Float.valueOf((String)rawValue));
        }
        return this.getDictId(rawValue);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof Float) {
            this.indexValue(rawValue);
            this.updateMinMax(((Float)rawValue).floatValue());
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                this.indexValue(value);
                this.updateMinMax(((Float)value).floatValue());
            }
        }
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        float lowerFloat = Float.parseFloat(lower);
        float upperFloat = Float.parseFloat(upper);
        float valueToCompare = ((Float)this.get(dictIdToCompare)).floatValue();
        if (includeLower ? valueToCompare < lowerFloat : valueToCompare <= lowerFloat) {
            return false;
        }
        return !(includeUpper ? valueToCompare > upperFloat : valueToCompare >= upperFloat);
    }

    @Override
    @Nonnull
    public Float getMinVal() {
        return Float.valueOf(this._min);
    }

    @Override
    @Nonnull
    public Float getMaxVal() {
        return Float.valueOf(this._max);
    }

    @Nonnull
    public float[] getSortedValues() {
        int numValues = this.length();
        float[] sortedValues = new float[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = ((Float)this.get(i)).floatValue();
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public int getIntValue(int dictId) {
        return ((Float)this.get(dictId)).intValue();
    }

    @Override
    public long getLongValue(int dictId) {
        return ((Float)this.get(dictId)).longValue();
    }

    @Override
    public float getFloatValue(int dictId) {
        return ((Float)this.get(dictId)).floatValue();
    }

    @Override
    public double getDoubleValue(int dictId) {
        return ((Float)this.get(dictId)).floatValue();
    }

    private void updateMinMax(float value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }
}

