/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.impl.FixedByteSingleColumnSingleValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOffHeapMutableDictionary;

public class IntOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private int _min = Integer.MAX_VALUE;
    private int _max = Integer.MIN_VALUE;
    private final FixedByteSingleColumnSingleValueReaderWriter _dictIdToValue;

    public IntOffHeapMutableDictionary(int estimatedCardinality, int maxOverflowSize, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        super(estimatedCardinality, maxOverflowSize, memoryManager, allocationContext);
        int initialEntryCount = this.nearestPowerOf2(estimatedCardinality);
        this._dictIdToValue = new FixedByteSingleColumnSingleValueReaderWriter(initialEntryCount, 4, memoryManager, allocationContext);
    }

    @Override
    public Object get(int dictionaryId) {
        return this._dictIdToValue.getInt(dictionaryId);
    }

    @Override
    public int indexOf(Object rawValue) {
        if (rawValue instanceof String) {
            return this.getDictId(Integer.valueOf((String)rawValue), null);
        }
        return this.getDictId(rawValue, null);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof Integer) {
            this.indexValue(rawValue, null);
            this.updateMinMax((Integer)rawValue);
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                this.indexValue(value, null);
                this.updateMinMax((Integer)value);
            }
        }
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        int lowerInt = Integer.parseInt(lower);
        int upperInt = Integer.parseInt(upper);
        int valueToCompare = (Integer)this.get(dictIdToCompare);
        if (includeLower ? valueToCompare < lowerInt : valueToCompare <= lowerInt) {
            return false;
        }
        return !(includeUpper ? valueToCompare > upperInt : valueToCompare >= upperInt);
    }

    @Override
    @Nonnull
    public Integer getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public Integer getMaxVal() {
        return this._max;
    }

    @Nonnull
    public int[] getSortedValues() {
        int numValues = this.length();
        int[] sortedValues = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = (Integer)this.get(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public int getAvgValueSize() {
        return 4;
    }

    @Override
    protected void setRawValueAt(int dictId, Object value, byte[] serializedValue) {
        this._dictIdToValue.setInt(dictId, (Integer)value);
    }

    @Override
    public int getIntValue(int dictId) {
        return (Integer)this.get(dictId);
    }

    @Override
    public long getLongValue(int dictId) {
        return ((Integer)this.get(dictId)).intValue();
    }

    @Override
    public float getFloatValue(int dictId) {
        return ((Integer)this.get(dictId)).intValue();
    }

    @Override
    public double getDoubleValue(int dictId) {
        return ((Integer)this.get(dictId)).intValue();
    }

    @Override
    public void doClose() throws IOException {
        this._dictIdToValue.close();
    }

    private void updateMinMax(int value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return super.getTotalOffHeapMemUsed() + (long)(this.length() * 4);
    }
}

