/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.impl.FixedByteSingleColumnSingleValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOffHeapMutableDictionary;

public class LongOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private long _min = Long.MAX_VALUE;
    private long _max = Long.MIN_VALUE;
    private final FixedByteSingleColumnSingleValueReaderWriter _dictIdToValue;

    public LongOffHeapMutableDictionary(int estimatedCardinality, int overflowSize, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        super(estimatedCardinality, overflowSize, memoryManager, allocationContext);
        int initialEntryCount = this.nearestPowerOf2(estimatedCardinality);
        this._dictIdToValue = new FixedByteSingleColumnSingleValueReaderWriter(initialEntryCount, 8, memoryManager, allocationContext);
    }

    @Override
    public Object get(int dictionaryId) {
        return this._dictIdToValue.getLong(dictionaryId);
    }

    @Override
    public int indexOf(Object rawValue) {
        if (rawValue instanceof String) {
            return this.getDictId(Long.valueOf((String)rawValue), null);
        }
        return this.getDictId(rawValue, null);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof Long) {
            this.indexValue(rawValue, null);
            this.updateMinMax((Long)rawValue);
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                this.indexValue(value, null);
                this.updateMinMax((Long)value);
            }
        }
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        long lowerLong = Long.parseLong(lower);
        long upperLong = Long.parseLong(upper);
        long valueToCompare = (Long)this.get(dictIdToCompare);
        if (includeLower ? valueToCompare < lowerLong : valueToCompare <= lowerLong) {
            return false;
        }
        return !(includeUpper ? valueToCompare > upperLong : valueToCompare >= upperLong);
    }

    @Override
    @Nonnull
    public Long getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public Long getMaxVal() {
        return this._max;
    }

    @Nonnull
    public long[] getSortedValues() {
        int numValues = this.length();
        long[] sortedValues = new long[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = (Long)this.get(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public int getAvgValueSize() {
        return 8;
    }

    @Override
    protected void setRawValueAt(int dictId, Object value, byte[] serializedValue) {
        this._dictIdToValue.setLong(dictId, (Long)value);
    }

    @Override
    public int getIntValue(int dictId) {
        return ((Long)this.get(dictId)).intValue();
    }

    @Override
    public long getLongValue(int dictId) {
        return (Long)this.get(dictId);
    }

    @Override
    public float getFloatValue(int dictId) {
        return ((Long)this.get(dictId)).floatValue();
    }

    @Override
    public double getDoubleValue(int dictId) {
        return ((Long)this.get(dictId)).doubleValue();
    }

    @Override
    public void doClose() throws IOException {
        this._dictIdToValue.close();
    }

    private void updateMinMax(long value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return super.getTotalOffHeapMemUsed() + (long)(this.length() * 8);
    }
}

