/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOnHeapMutableDictionary;

public class LongOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private long _min = Long.MAX_VALUE;
    private long _max = Long.MIN_VALUE;

    @Override
    public int indexOf(Object rawValue) {
        if (rawValue instanceof String) {
            return this.getDictId(Long.valueOf((String)rawValue));
        }
        return this.getDictId(rawValue);
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof Long) {
            this.indexValue(rawValue);
            this.updateMinMax((Long)rawValue);
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                this.indexValue(value);
                this.updateMinMax((Long)value);
            }
        }
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        long lowerLong = Long.parseLong(lower);
        long upperLong = Long.parseLong(upper);
        long valueToCompare = (Long)this.get(dictIdToCompare);
        if (includeLower ? valueToCompare < lowerLong : valueToCompare <= lowerLong) {
            return false;
        }
        return !(includeUpper ? valueToCompare > upperLong : valueToCompare >= upperLong);
    }

    @Override
    @Nonnull
    public Long getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public Long getMaxVal() {
        return this._max;
    }

    @Nonnull
    public long[] getSortedValues() {
        int numValues = this.length();
        long[] sortedValues = new long[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = (Long)this.get(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public int getIntValue(int dictId) {
        return ((Long)this.get(dictId)).intValue();
    }

    @Override
    public long getLongValue(int dictId) {
        return (Long)this.get(dictId);
    }

    @Override
    public float getFloatValue(int dictId) {
        return ((Long)this.get(dictId)).longValue();
    }

    @Override
    public double getDoubleValue(int dictId) {
        return ((Long)this.get(dictId)).longValue();
    }

    private void updateMinMax(long value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }
}

