/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.MutableOffHeapByteArrayStore;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.common.utils.StringUtil;

public class StringOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private final MutableOffHeapByteArrayStore _byteStore;
    private String _min = null;
    private String _max = null;

    public StringOffHeapMutableDictionary(int estimatedCardinality, int maxOverflowHashSize, PinotDataBufferMemoryManager memoryManager, String allocationContext, int avgStringLen) {
        super(estimatedCardinality, maxOverflowHashSize, memoryManager, allocationContext);
        this._byteStore = new MutableOffHeapByteArrayStore(memoryManager, allocationContext, estimatedCardinality, avgStringLen);
    }

    @Override
    public void doClose() throws IOException {
        this._byteStore.close();
    }

    @Override
    protected void setRawValueAt(int dictId, Object rawValue, byte[] serializedValue) {
        this._byteStore.add(serializedValue);
    }

    @Override
    public Object get(int dictionaryId) {
        return StringUtil.decodeUtf8(this._byteStore.get(dictionaryId));
    }

    @Override
    public void index(@Nonnull Object rawValue) {
        if (rawValue instanceof String) {
            byte[] serializedValue = StringUtil.encodeUtf8((String)rawValue);
            this.indexValue(rawValue, serializedValue);
            this.updateMinMax((String)rawValue);
        } else {
            Object[] values;
            for (Object value : values = (Object[])rawValue) {
                byte[] serializedValue = StringUtil.encodeUtf8((String)value);
                this.indexValue(value, serializedValue);
                this.updateMinMax((String)value);
            }
        }
    }

    private String getInternal(int dictId) {
        return StringUtil.decodeUtf8(this._byteStore.get(dictId));
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        String valueToCompare = this.getInternal(dictIdToCompare);
        return this.valueInRange(lower, upper, includeLower, includeUpper, valueToCompare);
    }

    @Override
    public int indexOf(Object rawValue) {
        byte[] serializedValue = StringUtil.encodeUtf8((String)rawValue);
        return this.getDictId(rawValue, serializedValue);
    }

    @Override
    @Nonnull
    public Object getMinVal() {
        return this._min;
    }

    @Override
    @Nonnull
    public Object getMaxVal() {
        return this._max;
    }

    @Override
    @Nonnull
    public Object getSortedValues() {
        int numValues = this.length();
        Object[] sortedValues = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            sortedValues[i] = this.getInternal(i);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    protected boolean equalsValueAt(int dictId, Object value, byte[] serializedValue) {
        return this._byteStore.equalsValueAt(serializedValue, dictId);
    }

    private void updateMinMax(String value) {
        if (this._min == null) {
            this._min = value;
            this._max = value;
        } else {
            if (value.compareTo(this._min) < 0) {
                this._min = value;
            }
            if (value.compareTo(this._max) > 0) {
                this._max = value;
            }
        }
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return super.getTotalOffHeapMemUsed() + this._byteStore.getTotalOffHeapMemUsed();
    }

    @Override
    public int getAvgValueSize() {
        return (int)this._byteStore.getAvgValueSize();
    }
}

