/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.invertedindex;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class RealtimeInvertedIndexReader
implements InvertedIndexReader<MutableRoaringBitmap> {
    private final List<ThreadSafeMutableRoaringBitmap> _bitmaps = new ArrayList<ThreadSafeMutableRoaringBitmap>();
    private final ReentrantReadWriteLock.ReadLock _readLock;
    private final ReentrantReadWriteLock.WriteLock _writeLock;

    public RealtimeInvertedIndexReader() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this._readLock = readWriteLock.readLock();
        this._writeLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int dictId, int docId) {
        if (this._bitmaps.size() == dictId) {
            ThreadSafeMutableRoaringBitmap bitmap = new ThreadSafeMutableRoaringBitmap(docId);
            try {
                this._writeLock.lock();
                this._bitmaps.add(bitmap);
            }
            finally {
                this._writeLock.unlock();
            }
        } else {
            this._bitmaps.get(dictId).checkAndAdd(docId);
        }
    }

    @Override
    public MutableRoaringBitmap getDocIds(int dictId) {
        ThreadSafeMutableRoaringBitmap bitmap;
        try {
            this._readLock.lock();
            bitmap = this._bitmaps.get(dictId);
        }
        finally {
            this._readLock.unlock();
        }
        return bitmap.getMutableRoaringBitmap();
    }

    @Override
    public void close() {
    }

    private static class ThreadSafeMutableRoaringBitmap {
        private MutableRoaringBitmap _mutableRoaringBitmap = new MutableRoaringBitmap();

        public ThreadSafeMutableRoaringBitmap(int firstDocId) {
            this._mutableRoaringBitmap.add(firstDocId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkAndAdd(int docId) {
            if (!this._mutableRoaringBitmap.contains(docId)) {
                ThreadSafeMutableRoaringBitmap threadSafeMutableRoaringBitmap = this;
                synchronized (threadSafeMutableRoaringBitmap) {
                    this._mutableRoaringBitmap.add(docId);
                }
            }
        }

        public synchronized MutableRoaringBitmap getMutableRoaringBitmap() {
            return this._mutableRoaringBitmap.clone();
        }
    }
}

