/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.TopicMetadataResponse;
import kafka.javaapi.consumer.SimpleConsumer;
import org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.com.google.common.base.Splitter;
import org.apache.pinot.$internal.com.google.common.collect.Lists;
import org.apache.pinot.$internal.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.pinot.$internal.org.apache.commons.lang3.StringUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaBrokerWrapper;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaLowLevelStreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaSimpleConsumerFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.PermanentConsumerException;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.TransientConsumerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaConnectionHandler.class);
    State _currentState;
    final String _clientId;
    final String _topic;
    final int _partition;
    final long _connectTimeoutMillis;
    String[] _bootstrapHosts;
    int[] _bootstrapPorts;
    KafkaBrokerWrapper _leader;
    String _currentHost;
    int _currentPort;
    int _bufferSize;
    int _socketTimeout;
    final KafkaSimpleConsumerFactory _simpleConsumerFactory;
    SimpleConsumer _simpleConsumer;
    final Random _random = new Random();
    boolean isPartitionProvided;

    @VisibleForTesting
    public SimpleConsumer getSimpleConsumer() {
        return this._simpleConsumer;
    }

    public KafkaConnectionHandler(String clientId, StreamConfig streamConfig, KafkaSimpleConsumerFactory simpleConsumerFactory) {
        KafkaLowLevelStreamConfig kafkaLowLevelStreamConfig = new KafkaLowLevelStreamConfig(streamConfig);
        this._simpleConsumerFactory = simpleConsumerFactory;
        this._clientId = clientId;
        this._topic = kafkaLowLevelStreamConfig.getKafkaTopicName();
        this._connectTimeoutMillis = streamConfig.getConnectionTimeoutMillis();
        this._simpleConsumer = null;
        this.isPartitionProvided = false;
        this._partition = Integer.MIN_VALUE;
        this._bufferSize = kafkaLowLevelStreamConfig.getKafkaBufferSize();
        this._socketTimeout = kafkaLowLevelStreamConfig.getKafkaSocketTimeout();
        this.initializeBootstrapNodeList(kafkaLowLevelStreamConfig.getBootstrapHosts());
        this.setCurrentState(new ConnectingToBootstrapNode());
    }

    public KafkaConnectionHandler(String clientId, StreamConfig streamConfig, int partition, KafkaSimpleConsumerFactory simpleConsumerFactory) {
        KafkaLowLevelStreamConfig kafkaLowLevelStreamConfig = new KafkaLowLevelStreamConfig(streamConfig);
        this._simpleConsumerFactory = simpleConsumerFactory;
        this._clientId = clientId;
        this._topic = kafkaLowLevelStreamConfig.getKafkaTopicName();
        this._connectTimeoutMillis = streamConfig.getConnectionTimeoutMillis();
        this._simpleConsumer = null;
        this.isPartitionProvided = true;
        this._partition = partition;
        this._bufferSize = kafkaLowLevelStreamConfig.getKafkaBufferSize();
        this._socketTimeout = kafkaLowLevelStreamConfig.getKafkaSocketTimeout();
        this.initializeBootstrapNodeList(kafkaLowLevelStreamConfig.getBootstrapHosts());
        this.setCurrentState(new ConnectingToBootstrapNode());
    }

    void initializeBootstrapNodeList(String bootstrapNodes) {
        if (StringUtils.isBlank(bootstrapNodes)) {
            throw new IllegalArgumentException("Need at least one bootstrap host");
        }
        ArrayList<String> hostsAndPorts = Lists.newArrayList(Splitter.on(',').trimResults().omitEmptyStrings().split(bootstrapNodes));
        int bootstrapHostCount = hostsAndPorts.size();
        this._bootstrapHosts = new String[bootstrapHostCount];
        this._bootstrapPorts = new int[bootstrapHostCount];
        for (int i = 0; i < bootstrapHostCount; ++i) {
            String hostAndPort = hostsAndPorts.get(i);
            String[] splitHostAndPort = hostAndPort.split(":");
            if (splitHostAndPort.length != 2) {
                throw new IllegalArgumentException("Unable to parse host:port combination for " + hostAndPort);
            }
            this._bootstrapHosts[i] = splitHostAndPort[0];
            try {
                this._bootstrapPorts[i] = Integer.parseInt(splitHostAndPort[1]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse port number " + splitHostAndPort[1] + " for host:port combination " + hostAndPort);
            }
        }
    }

    private void setCurrentState(State newState) {
        if (this._currentState != null) {
            LOGGER.info("Switching from state {} to state {} for topic {}", new Object[]{this._currentState.getStateValue(), newState.getStateValue(), this._topic});
        }
        this._currentState = newState;
    }

    RuntimeException exceptionForKafkaErrorCode(short kafkaErrorCode) {
        Errors kafkaError = Errors.forCode((short)kafkaErrorCode);
        switch (kafkaError) {
            case UNKNOWN: 
            case OFFSET_OUT_OF_RANGE: 
            case CORRUPT_MESSAGE: 
            case MESSAGE_TOO_LARGE: 
            case OFFSET_METADATA_TOO_LARGE: 
            case INVALID_TOPIC_EXCEPTION: 
            case RECORD_LIST_TOO_LARGE: 
            case INVALID_REQUIRED_ACKS: 
            case ILLEGAL_GENERATION: 
            case INCONSISTENT_GROUP_PROTOCOL: 
            case INVALID_GROUP_ID: 
            case UNKNOWN_MEMBER_ID: 
            case INVALID_SESSION_TIMEOUT: 
            case INVALID_COMMIT_OFFSET_SIZE: {
                return new PermanentConsumerException(new KafkaPermanentConsumerException(kafkaError));
            }
            case UNKNOWN_TOPIC_OR_PARTITION: 
            case LEADER_NOT_AVAILABLE: 
            case NOT_LEADER_FOR_PARTITION: 
            case REQUEST_TIMED_OUT: 
            case BROKER_NOT_AVAILABLE: 
            case REPLICA_NOT_AVAILABLE: 
            case STALE_CONTROLLER_EPOCH: 
            case NETWORK_EXCEPTION: 
            case GROUP_LOAD_IN_PROGRESS: 
            case GROUP_COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR_FOR_GROUP: 
            case NOT_ENOUGH_REPLICAS: 
            case NOT_ENOUGH_REPLICAS_AFTER_APPEND: 
            case REBALANCE_IN_PROGRESS: 
            case TOPIC_AUTHORIZATION_FAILED: 
            case GROUP_AUTHORIZATION_FAILED: 
            case CLUSTER_AUTHORIZATION_FAILED: {
                return new TransientConsumerException(new KafkaTransientConsumerException(kafkaError));
            }
        }
        return new RuntimeException("Unhandled error " + kafkaError);
    }

    void close() throws IOException {
        boolean needToCloseConsumer = this._currentState.isConnectedToKafkaBroker() && this._simpleConsumer != null;
        this.setCurrentState(new ConnectingToBootstrapNode());
        if (needToCloseConsumer) {
            this._simpleConsumer.close();
            this._simpleConsumer = null;
        }
    }

    private class ConnectedToPartitionLeader
    extends State {
        public ConnectedToPartitionLeader() {
            super(ConsumerState.CONNECTED_TO_PARTITION_LEADER);
        }

        @Override
        void process() {
        }

        @Override
        boolean isConnectedToKafkaBroker() {
            return true;
        }
    }

    private class ConnectingToPartitionLeader
    extends State {
        public ConnectingToPartitionLeader() {
            super(ConsumerState.CONNECTING_TO_PARTITION_LEADER);
        }

        @Override
        void process() {
            LOGGER.info("Trying to fetch leader host and port: {}:{} for topic {}", new Object[]{KafkaConnectionHandler.this._leader.host(), KafkaConnectionHandler.this._leader.port(), KafkaConnectionHandler.this._topic});
            if (KafkaConnectionHandler.this._leader.host().equals(KafkaConnectionHandler.this._currentHost) && KafkaConnectionHandler.this._leader.port() == KafkaConnectionHandler.this._currentPort) {
                KafkaConnectionHandler.this.setCurrentState(new ConnectedToPartitionLeader());
                return;
            }
            if (KafkaConnectionHandler.this._simpleConsumer != null) {
                try {
                    KafkaConnectionHandler.this._simpleConsumer.close();
                    KafkaConnectionHandler.this._simpleConsumer = null;
                }
                catch (Exception e) {
                    this.handleConsumerException(e);
                    return;
                }
            }
            try {
                KafkaConnectionHandler.this._simpleConsumer = KafkaConnectionHandler.this._simpleConsumerFactory.buildSimpleConsumer(KafkaConnectionHandler.this._leader.host(), KafkaConnectionHandler.this._leader.port(), KafkaConnectionHandler.this._socketTimeout, KafkaConnectionHandler.this._bufferSize, KafkaConnectionHandler.this._clientId);
                KafkaConnectionHandler.this.setCurrentState(new ConnectedToPartitionLeader());
            }
            catch (Exception e) {
                this.handleConsumerException(e);
            }
        }

        @Override
        boolean isConnectedToKafkaBroker() {
            return false;
        }
    }

    private class FetchingLeaderInformation
    extends State {
        public FetchingLeaderInformation() {
            super(ConsumerState.FETCHING_LEADER_INFORMATION);
        }

        @Override
        void process() {
            block6: {
                try {
                    TopicMetadataResponse response = KafkaConnectionHandler.this._simpleConsumer.send(new TopicMetadataRequest(Collections.singletonList(KafkaConnectionHandler.this._topic)));
                    try {
                        KafkaConnectionHandler.this._leader = null;
                        List pMetaList = ((TopicMetadata)response.topicsMetadata().get(0)).partitionsMetadata();
                        for (PartitionMetadata pMeta : pMetaList) {
                            if (pMeta.partitionId() != KafkaConnectionHandler.this._partition) continue;
                            KafkaConnectionHandler.this._leader = new KafkaBrokerWrapper(pMeta.leader());
                            break;
                        }
                        if (KafkaConnectionHandler.this._leader != null) {
                            LOGGER.info("Located leader broker {} for topic {}, connecting to it.", (Object)KafkaConnectionHandler.this._leader, (Object)KafkaConnectionHandler.this._topic);
                            KafkaConnectionHandler.this.setCurrentState(new ConnectingToPartitionLeader());
                            break block6;
                        }
                        LOGGER.warn("Leader broker is null for topic {}, retrying leader fetch in 100ms", (Object)KafkaConnectionHandler.this._topic);
                        Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to get the leader broker for topic {} due to exception, retrying in 100ms", (Object)KafkaConnectionHandler.this._topic, (Object)e);
                        Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception e) {
                    this.handleConsumerException(e);
                }
            }
        }

        @Override
        boolean isConnectedToKafkaBroker() {
            return true;
        }
    }

    private class ConnectedToBootstrapNode
    extends State {
        protected ConnectedToBootstrapNode() {
            super(ConsumerState.CONNECTED_TO_BOOTSTRAP_NODE);
        }

        @Override
        void process() {
            if (KafkaConnectionHandler.this.isPartitionProvided) {
                KafkaConnectionHandler.this.setCurrentState(new FetchingLeaderInformation());
            }
        }

        @Override
        boolean isConnectedToKafkaBroker() {
            return true;
        }
    }

    private class ConnectingToBootstrapNode
    extends State {
        public ConnectingToBootstrapNode() {
            super(ConsumerState.CONNECTING_TO_BOOTSTRAP_NODE);
        }

        @Override
        public void process() {
            if (KafkaConnectionHandler.this._simpleConsumer != null) {
                try {
                    KafkaConnectionHandler.this._simpleConsumer.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Caught exception while closing consumer for topic {}, ignoring", (Object)KafkaConnectionHandler.this._topic, (Object)e);
                }
            }
            int randomHostIndex = KafkaConnectionHandler.this._random.nextInt(KafkaConnectionHandler.this._bootstrapHosts.length);
            KafkaConnectionHandler.this._currentHost = KafkaConnectionHandler.this._bootstrapHosts[randomHostIndex];
            KafkaConnectionHandler.this._currentPort = KafkaConnectionHandler.this._bootstrapPorts[randomHostIndex];
            try {
                LOGGER.info("Connecting to bootstrap host {}:{} for topic {}", new Object[]{KafkaConnectionHandler.this._currentHost, KafkaConnectionHandler.this._currentPort, KafkaConnectionHandler.this._topic});
                KafkaConnectionHandler.this._simpleConsumer = KafkaConnectionHandler.this._simpleConsumerFactory.buildSimpleConsumer(KafkaConnectionHandler.this._currentHost, KafkaConnectionHandler.this._currentPort, KafkaConnectionHandler.this._socketTimeout, KafkaConnectionHandler.this._bufferSize, KafkaConnectionHandler.this._clientId);
                KafkaConnectionHandler.this.setCurrentState(new ConnectedToBootstrapNode());
            }
            catch (Exception e) {
                this.handleConsumerException(e);
            }
        }

        @Override
        boolean isConnectedToKafkaBroker() {
            return false;
        }
    }

    abstract class State {
        private ConsumerState stateValue;

        protected State(ConsumerState stateValue) {
            this.stateValue = stateValue;
        }

        abstract void process();

        abstract boolean isConnectedToKafkaBroker();

        void handleConsumerException(Exception e) {
            LOGGER.warn("Caught Kafka consumer exception while in state {}, disconnecting and trying again for topic {}", new Object[]{KafkaConnectionHandler.this._currentState.getStateValue(), KafkaConnectionHandler.this._topic, e});
            Uninterruptibles.sleepUninterruptibly(250L, TimeUnit.MILLISECONDS);
            KafkaConnectionHandler.this.setCurrentState(new ConnectingToBootstrapNode());
        }

        ConsumerState getStateValue() {
            return this.stateValue;
        }
    }

    private class KafkaTransientConsumerException
    extends RuntimeException {
        public KafkaTransientConsumerException(Errors error) {
            super((Throwable)error.exception());
        }
    }

    private class KafkaPermanentConsumerException
    extends RuntimeException {
        public KafkaPermanentConsumerException(Errors error) {
            super((Throwable)error.exception());
        }
    }

    static enum ConsumerState {
        CONNECTING_TO_BOOTSTRAP_NODE,
        CONNECTED_TO_BOOTSTRAP_NODE,
        FETCHING_LEADER_INFORMATION,
        CONNECTING_TO_PARTITION_LEADER,
        CONNECTED_TO_PARTITION_LEADER;

    }
}

