/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamMessageDecoder;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaJSONMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaJSONMessageDecoder.class);
    private Schema schema;

    @Override
    public void init(Map<String, String> props, Schema indexingSchema, String topicName) throws Exception {
        this.schema = indexingSchema;
    }

    @Override
    public GenericRow decode(byte[] payload, GenericRow destination) {
        try {
            JsonNode message = JsonUtils.bytesToJsonNode(payload);
            for (FieldSpec fieldSpec : this.schema.getAllFieldSpecs()) {
                String column = fieldSpec.getName();
                destination.putField(column, JsonUtils.extractValue(message.get(column), fieldSpec));
            }
            return destination;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while decoding row, discarding row.", (Throwable)e);
            return null;
        }
    }

    @Override
    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        return this.decode(Arrays.copyOfRange(payload, offset, offset + length), destination);
    }
}

