/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.common.TopicAndPartition;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.TopicMetadataResponse;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaConnectionHandler;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaSimpleConsumerFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.kafka.KafkaSimpleConsumerFactoryImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.OffsetCriteria;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamMetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStreamMetadataProvider
extends KafkaConnectionHandler
implements StreamMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaStreamMetadataProvider.class);

    public KafkaStreamMetadataProvider(String clientId, StreamConfig streamConfig, int partition) {
        super(clientId, streamConfig, partition, new KafkaSimpleConsumerFactoryImpl());
    }

    public KafkaStreamMetadataProvider(String clientId, StreamConfig streamConfig) {
        super(clientId, streamConfig, new KafkaSimpleConsumerFactoryImpl());
    }

    @VisibleForTesting
    public KafkaStreamMetadataProvider(String clientId, StreamConfig streamConfig, int partition, KafkaSimpleConsumerFactory kafkaSimpleConsumerFactory) {
        super(clientId, streamConfig, partition, kafkaSimpleConsumerFactory);
    }

    @VisibleForTesting
    public KafkaStreamMetadataProvider(String clientId, StreamConfig streamConfig, KafkaSimpleConsumerFactory kafkaSimpleConsumerFactory) {
        super(clientId, streamConfig, kafkaSimpleConsumerFactory);
    }

    @Override
    public synchronized int fetchPartitionCount(long timeoutMillis) {
        int unknownTopicReplyCount = 0;
        int MAX_UNKNOWN_TOPIC_REPLY_COUNT = 10;
        int kafkaErrorCount = 0;
        int MAX_KAFKA_ERROR_COUNT = 10;
        long endTime = System.currentTimeMillis() + timeoutMillis;
        while (System.currentTimeMillis() < endTime) {
            while (!this._currentState.isConnectedToKafkaBroker() && System.currentTimeMillis() < endTime) {
                this._currentState.process();
            }
            if (endTime <= System.currentTimeMillis() && !this._currentState.isConnectedToKafkaBroker()) {
                throw new TimeoutException("Failed to get the partition count for topic " + this._topic + " within " + timeoutMillis + " ms");
            }
            TopicMetadataResponse topicMetadataResponse = null;
            try {
                topicMetadataResponse = this._simpleConsumer.send(new TopicMetadataRequest(Collections.singletonList(this._topic)));
            }
            catch (Exception e) {
                this._currentState.handleConsumerException(e);
                continue;
            }
            TopicMetadata topicMetadata = (TopicMetadata)topicMetadataResponse.topicsMetadata().get(0);
            short errorCode = topicMetadata.errorCode();
            if (errorCode == Errors.NONE.code()) {
                return topicMetadata.partitionsMetadata().size();
            }
            if (errorCode == Errors.LEADER_NOT_AVAILABLE.code()) {
                Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            if (errorCode == Errors.INVALID_TOPIC_EXCEPTION.code()) {
                throw new RuntimeException("Invalid topic name " + this._topic);
            }
            if (errorCode == Errors.UNKNOWN_TOPIC_OR_PARTITION.code()) {
                if (10 < unknownTopicReplyCount) {
                    throw new RuntimeException("Topic " + this._topic + " does not exist");
                }
                ++unknownTopicReplyCount;
                Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            if (10 < ++kafkaErrorCount) {
                throw this.exceptionForKafkaErrorCode(errorCode);
            }
            Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
        }
        throw new TimeoutException();
    }

    @Override
    public synchronized long fetchPartitionOffset(@Nonnull OffsetCriteria offsetCriteria, long timeoutMillis) throws java.util.concurrent.TimeoutException {
        long offsetRequestTime;
        Preconditions.checkState(this.isPartitionProvided, "Cannot fetch partition offset. StreamMetadataProvider created without partition information");
        Preconditions.checkNotNull(offsetCriteria);
        if (offsetCriteria.isLargest()) {
            offsetRequestTime = kafka.api.OffsetRequest.LatestTime();
        } else if (offsetCriteria.isSmallest()) {
            offsetRequestTime = kafka.api.OffsetRequest.EarliestTime();
        } else {
            throw new IllegalArgumentException("Unknown initial offset value " + offsetCriteria.toString());
        }
        int kafkaErrorCount = 0;
        int MAX_KAFKA_ERROR_COUNT = 10;
        long endTime = System.currentTimeMillis() + timeoutMillis;
        while (System.currentTimeMillis() < endTime) {
            OffsetResponse offsetResponse;
            while (this._currentState.getStateValue() != KafkaConnectionHandler.ConsumerState.CONNECTED_TO_PARTITION_LEADER && System.currentTimeMillis() < endTime) {
                this._currentState.process();
            }
            if (this._currentState.getStateValue() != KafkaConnectionHandler.ConsumerState.CONNECTED_TO_PARTITION_LEADER && endTime <= System.currentTimeMillis()) {
                throw new TimeoutException();
            }
            OffsetRequest request = new OffsetRequest(Collections.singletonMap(new TopicAndPartition(this._topic, this._partition), new PartitionOffsetRequestInfo(offsetRequestTime, 1)), kafka.api.OffsetRequest.CurrentVersion(), this._clientId);
            try {
                offsetResponse = this._simpleConsumer.getOffsetsBefore(request);
            }
            catch (Exception e) {
                this._currentState.handleConsumerException(e);
                continue;
            }
            short errorCode = offsetResponse.errorCode(this._topic, this._partition);
            if (errorCode == Errors.NONE.code()) {
                long offset = offsetResponse.offsets(this._topic, this._partition)[0];
                if (offset == 0L) {
                    LOGGER.warn("Fetched offset of 0 for topic {} and partition {}, is this a newly created topic?", (Object)this._topic, (Object)this._partition);
                }
                return offset;
            }
            if (errorCode == Errors.LEADER_NOT_AVAILABLE.code()) {
                Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                continue;
            }
            if (10 < ++kafkaErrorCount) {
                throw this.exceptionForKafkaErrorCode(errorCode);
            }
            Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
        }
        throw new TimeoutException();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

