/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream;

import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.time.TimeUtils;

public class OffsetCriteria {
    public static final OffsetCriteria SMALLEST_OFFSET_CRITERIA = new OffsetCriteriaBuilder().withOffsetSmallest();
    private OffsetType _offsetType;
    private String _offsetString;

    private OffsetCriteria() {
    }

    private void setOffsetType(OffsetType offsetType) {
        this._offsetType = offsetType;
    }

    private void setOffsetString(String offsetString) {
        this._offsetString = offsetString;
    }

    public boolean isSmallest() {
        return this._offsetType != null && this._offsetType.equals((Object)OffsetType.SMALLEST);
    }

    public boolean isLargest() {
        return this._offsetType != null && this._offsetType.equals((Object)OffsetType.LARGEST);
    }

    public boolean isPeriod() {
        return this._offsetType != null && this._offsetType.equals((Object)OffsetType.PERIOD);
    }

    public boolean isCustom() {
        return this._offsetType != null && this._offsetType.equals((Object)OffsetType.CUSTOM);
    }

    public String getOffsetString() {
        return this._offsetString;
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        OffsetCriteria that = (OffsetCriteria)o;
        return EqualityUtils.isEqual((Object)this._offsetType, (Object)that._offsetType) && EqualityUtils.isEqual(this._offsetString, that._offsetString);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf((Object)this._offsetType);
        result = EqualityUtils.hashCodeOf(result, this._offsetString);
        return result;
    }

    public String toString() {
        return "OffsetCriteria{_offsetType=" + (Object)((Object)this._offsetType) + ", _offsetString='" + this._offsetString + '\'' + '}';
    }

    public static class OffsetCriteriaBuilder {
        private OffsetCriteria _offsetCriteria = new OffsetCriteria();

        public OffsetCriteria withOffsetSmallest() {
            this._offsetCriteria.setOffsetType(OffsetType.SMALLEST);
            this._offsetCriteria.setOffsetString(OffsetType.SMALLEST.toString().toLowerCase());
            return this._offsetCriteria;
        }

        public OffsetCriteria withOffsetLargest() {
            this._offsetCriteria.setOffsetType(OffsetType.LARGEST);
            this._offsetCriteria.setOffsetString(OffsetType.LARGEST.toString().toLowerCase());
            return this._offsetCriteria;
        }

        public OffsetCriteria withOffsetAsPeriod(String periodString) {
            Preconditions.checkNotNull(periodString, "Must provide period string eg. 10d, 4h30m etc");
            this._offsetCriteria.setOffsetType(OffsetType.PERIOD);
            this._offsetCriteria.setOffsetString(periodString);
            return this._offsetCriteria;
        }

        public OffsetCriteria withOffsetCustom(String customString) {
            Preconditions.checkNotNull(customString, "Must provide custom offset criteria string");
            this._offsetCriteria.setOffsetType(OffsetType.CUSTOM);
            this._offsetCriteria.setOffsetString(customString);
            return this._offsetCriteria;
        }

        public OffsetCriteria withOffsetString(String offsetString) {
            Preconditions.checkNotNull(offsetString, "Must provide offset string");
            if (offsetString.equalsIgnoreCase(OffsetType.SMALLEST.toString())) {
                this._offsetCriteria.setOffsetType(OffsetType.SMALLEST);
            } else if (offsetString.equalsIgnoreCase(OffsetType.LARGEST.toString())) {
                this._offsetCriteria.setOffsetType(OffsetType.LARGEST);
            } else {
                try {
                    Long periodToMillis = TimeUtils.convertPeriodToMillis(offsetString);
                    if (periodToMillis >= 0L) {
                        this._offsetCriteria.setOffsetType(OffsetType.PERIOD);
                    } else {
                        this._offsetCriteria.setOffsetType(OffsetType.CUSTOM);
                    }
                }
                catch (Exception e) {
                    this._offsetCriteria.setOffsetType(OffsetType.CUSTOM);
                }
            }
            this._offsetCriteria.setOffsetString(offsetString);
            return this._offsetCriteria;
        }
    }

    private static enum OffsetType {
        SMALLEST,
        LARGEST,
        PERIOD,
        CUSTOM;

    }
}

