/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream;

import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.apache.pinot.common.utils.time.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionLevelStreamConfig
extends StreamConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionLevelStreamConfig.class);
    private final int _flushThresholdRows;
    private final long _flushThresholdTimeMillis;

    public PartitionLevelStreamConfig(Map<String, String> streamConfigMap) {
        super(streamConfigMap);
        int flushThresholdRows = super.getFlushThresholdRows();
        String flushThresholdRowsKey = "realtime.segment.flush.threshold.size.llc";
        String flushThresholdRowsValue = streamConfigMap.get(flushThresholdRowsKey);
        if (flushThresholdRowsValue != null) {
            try {
                flushThresholdRows = Integer.parseInt(flushThresholdRowsValue);
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception when parsing low level flush threshold rows {}:{}, defaulting to base value {}", new Object[]{flushThresholdRowsKey, flushThresholdRowsValue, flushThresholdRows, e});
            }
        }
        this._flushThresholdRows = flushThresholdRows;
        long flushThresholdTime = super.getFlushThresholdTimeMillis();
        String flushThresholdTimeKey = "realtime.segment.flush.threshold.time.llc";
        String flushThresholdTimeValue = streamConfigMap.get(flushThresholdTimeKey);
        if (flushThresholdTimeValue != null) {
            try {
                flushThresholdTime = TimeUtils.convertPeriodToMillis(flushThresholdTimeValue);
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception when converting low level flush threshold period to millis {}:{}, defaulting to base value {}", new Object[]{flushThresholdTimeKey, flushThresholdTimeValue, flushThresholdTime, e});
            }
        }
        this._flushThresholdTimeMillis = flushThresholdTime;
    }

    @Override
    public long getFlushThresholdTimeMillis() {
        return this._flushThresholdTimeMillis;
    }

    @Override
    public int getFlushThresholdRows() {
        return this._flushThresholdRows;
    }
}

