/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream;

import java.util.concurrent.Callable;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.OffsetCriteria;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConsumerFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.StreamMetadataProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.stream.TransientConsumerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionOffsetFetcher
implements Callable<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionOffsetFetcher.class);
    private static final int STREAM_PARTITION_OFFSET_FETCH_TIMEOUT_MILLIS = 10000;
    private final String _topicName;
    private final OffsetCriteria _offsetCriteria;
    private final int _partitionId;
    private Exception _exception = null;
    private long _offset = -1L;
    private StreamConsumerFactory _streamConsumerFactory;
    StreamConfig _streamConfig;

    public PartitionOffsetFetcher(OffsetCriteria offsetCriteria, int partitionId, StreamConfig streamConfig) {
        this._offsetCriteria = offsetCriteria;
        this._partitionId = partitionId;
        this._streamConfig = streamConfig;
        this._streamConsumerFactory = StreamConsumerFactoryProvider.create(streamConfig);
        this._topicName = streamConfig.getTopicName();
    }

    public long getOffset() {
        return this._offset;
    }

    public Exception getException() {
        return this._exception;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean call() throws Exception {
        String clientId = PartitionOffsetFetcher.class.getSimpleName() + "-" + this._topicName + "-" + this._partitionId;
        try (StreamMetadataProvider streamMetadataProvider = this._streamConsumerFactory.createPartitionMetadataProvider(clientId, this._partitionId);){
            this._offset = streamMetadataProvider.fetchPartitionOffset(this._offsetCriteria, 10000L);
            if (this._exception != null) {
                LOGGER.info("Successfully retrieved offset({}) for stream topic {} partition {}", new Object[]{this._offset, this._topicName, this._partitionId});
            }
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (TransientConsumerException e) {
            LOGGER.warn("Temporary exception when fetching offset for topic {} partition {}:{}", new Object[]{this._topicName, this._partitionId, e.getMessage()});
            this._exception = e;
            return Boolean.FALSE;
        }
        catch (Exception e) {
            this._exception = e;
            throw e;
        }
    }
}

