/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.$internal.org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.PinotDataBitSet;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.BaseSingleValueRawIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnIndexCreationInfo;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.InvertedIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.MultiValueForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentIndexCreationInfo;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SingleValueForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SingleValueRawIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.SingleValueFixedByteRawIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.SingleValueUnsortedForwardIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd.SingleValueVarByteRawIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.inv.OffHeapBitmapInvertedIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.inv.OnHeapBitmapInvertedIndexCreator;
import org.apache.pinot.common.data.DateTimeFieldSpec;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.data.StarTreeIndexSpec;
import org.apache.pinot.startree.hll.HllConfig;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentColumnarIndexCreator
implements SegmentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentColumnarIndexCreator.class);
    private SegmentGeneratorConfig config;
    private Map<String, ColumnIndexCreationInfo> indexCreationInfoMap;
    private Map<String, SegmentDictionaryCreator> _dictionaryCreatorMap = new HashMap<String, SegmentDictionaryCreator>();
    private Map<String, ForwardIndexCreator> _forwardIndexCreatorMap = new HashMap<String, ForwardIndexCreator>();
    private Map<String, InvertedIndexCreator> _invertedIndexCreatorMap = new HashMap<String, InvertedIndexCreator>();
    private String segmentName;
    private Schema schema;
    private File _indexDir;
    private int totalDocs;
    private int totalRawDocs;
    private int totalAggDocs;
    private int docIdCounter;

    @Override
    public void init(SegmentGeneratorConfig segmentCreationSpec, SegmentIndexCreationInfo segmentIndexCreationInfo, Map<String, ColumnIndexCreationInfo> indexCreationInfoMap, Schema schema, File outDir) throws Exception {
        this.docIdCounter = 0;
        this.config = segmentCreationSpec;
        this.indexCreationInfoMap = indexCreationInfoMap;
        Preconditions.checkState(!outDir.exists(), "Segment output directory: %s already exists", (Object)outDir);
        Preconditions.checkState(outDir.mkdirs(), "Failed to create output directory: %s", (Object)outDir);
        this._indexDir = outDir;
        this.schema = schema;
        this.totalDocs = segmentIndexCreationInfo.getTotalDocs();
        this.totalAggDocs = segmentIndexCreationInfo.getTotalAggDocs();
        this.totalRawDocs = segmentIndexCreationInfo.getTotalRawDocs();
        Collection<FieldSpec> fieldSpecs = schema.getAllFieldSpecs();
        HashSet<String> invertedIndexColumns = new HashSet<String>();
        for (String columnName : this.config.getInvertedIndexCreationColumns()) {
            Preconditions.checkState(schema.hasColumn(columnName), "Cannot create inverted index for column: %s because it is not in schema", (Object)columnName);
            invertedIndexColumns.add(columnName);
        }
        for (FieldSpec fieldSpec : fieldSpecs) {
            String columnName = fieldSpec.getName();
            if (schema.isVirtualColumn(columnName)) continue;
            ColumnIndexCreationInfo indexCreationInfo = indexCreationInfoMap.get(columnName);
            Preconditions.checkNotNull(indexCreationInfo, "Missing index creation info for column: %s", (Object)columnName);
            if (this.createDictionaryForColumn(indexCreationInfo, segmentCreationSpec, fieldSpec)) {
                SegmentDictionaryCreator dictionaryCreator = new SegmentDictionaryCreator(indexCreationInfo.getSortedUniqueElementsArray(), fieldSpec, this._indexDir);
                this._dictionaryCreatorMap.put(columnName, dictionaryCreator);
                try {
                    dictionaryCreator.build();
                }
                catch (Exception e) {
                    LOGGER.error("Error building dictionary for field: {}, cardinality: {}, number of bytes per entry: {}", new Object[]{fieldSpec.getName(), indexCreationInfo.getDistinctValueCount(), dictionaryCreator.getNumBytesPerEntry()});
                    throw e;
                }
                int cardinality = indexCreationInfo.getDistinctValueCount();
                if (fieldSpec.isSingleValueField()) {
                    if (indexCreationInfo.isSorted()) {
                        this._forwardIndexCreatorMap.put(columnName, new SingleValueSortedForwardIndexCreator(this._indexDir, columnName, cardinality));
                    } else {
                        this._forwardIndexCreatorMap.put(columnName, new SingleValueUnsortedForwardIndexCreator(this._indexDir, columnName, cardinality, this.totalDocs));
                    }
                } else {
                    this._forwardIndexCreatorMap.put(columnName, new MultiValueUnsortedForwardIndexCreator(this._indexDir, columnName, cardinality, this.totalDocs, indexCreationInfo.getTotalNumberOfEntries()));
                }
                if (!invertedIndexColumns.contains(columnName)) continue;
                if (segmentCreationSpec.isOnHeap()) {
                    this._invertedIndexCreatorMap.put(columnName, new OnHeapBitmapInvertedIndexCreator(this._indexDir, columnName, cardinality));
                    continue;
                }
                this._invertedIndexCreatorMap.put(columnName, new OffHeapBitmapInvertedIndexCreator(this._indexDir, fieldSpec, cardinality, this.totalDocs, indexCreationInfo.getTotalNumberOfEntries()));
                continue;
            }
            Preconditions.checkState(fieldSpec.isSingleValueField(), "Cannot create raw index for multi-value column: %s", (Object)columnName);
            Preconditions.checkState(!invertedIndexColumns.contains(columnName), "Cannot create inverted index for raw index column: %s", (Object)columnName);
            .ChunkCompressorFactory.CompressionType compressionType = this.getColumnCompressionType(segmentCreationSpec, fieldSpec);
            this._forwardIndexCreatorMap.put(columnName, SegmentColumnarIndexCreator.getRawIndexCreatorForColumn(this._indexDir, compressionType, columnName, fieldSpec.getDataType(), this.totalDocs, indexCreationInfo.getLengthOfLongestEntry()));
        }
    }

    private .ChunkCompressorFactory.CompressionType getColumnCompressionType(SegmentGeneratorConfig segmentCreationSpec, FieldSpec fieldSpec) {
        .ChunkCompressorFactory.CompressionType compressionType = segmentCreationSpec.getRawIndexCompressionType().get(fieldSpec.getName());
        if (compressionType == null) {
            if (fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.METRIC)) {
                return .ChunkCompressorFactory.CompressionType.PASS_THROUGH;
            }
            return .ChunkCompressorFactory.CompressionType.SNAPPY;
        }
        return compressionType;
    }

    private boolean createDictionaryForColumn(ColumnIndexCreationInfo info, SegmentGeneratorConfig config, FieldSpec spec) {
        String column = spec.getName();
        if (config.getRawIndexCreationColumns().contains(column) || config.getRawIndexCompressionType().containsKey(column)) {
            if (!spec.isSingleValueField()) {
                throw new RuntimeException("Creation of indices without dictionaries is supported for single valued columns only.");
            }
            return false;
        }
        if (spec.getDataType().equals((Object)FieldSpec.DataType.BYTES) && !info.isFixedLength()) {
            return false;
        }
        return info.isCreateDictionary();
    }

    @Override
    public void indexRow(GenericRow row) {
        for (String columnName : this._forwardIndexCreatorMap.keySet()) {
            Object columnValueToIndex = row.getValue(columnName);
            if (columnValueToIndex == null) {
                throw new RuntimeException("Null value for column:" + columnName);
            }
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(columnName);
            if (this.schema.getFieldSpecFor(columnName).isSingleValueField()) {
                if (dictionaryCreator != null) {
                    int dictId = dictionaryCreator.indexOfSV(columnValueToIndex);
                    ((SingleValueForwardIndexCreator)this._forwardIndexCreatorMap.get(columnName)).index(this.docIdCounter, dictId);
                    if (!this._invertedIndexCreatorMap.containsKey(columnName)) continue;
                    this._invertedIndexCreatorMap.get(columnName).add(dictId);
                    continue;
                }
                ((SingleValueRawIndexCreator)this._forwardIndexCreatorMap.get(columnName)).index(this.docIdCounter, columnValueToIndex);
                continue;
            }
            int[] dictIds = dictionaryCreator.indexOfMV(columnValueToIndex);
            ((MultiValueForwardIndexCreator)this._forwardIndexCreatorMap.get(columnName)).index(this.docIdCounter, dictIds);
            if (!this._invertedIndexCreatorMap.containsKey(columnName)) continue;
            this._invertedIndexCreatorMap.get(columnName).add(dictIds, dictIds.length);
        }
        ++this.docIdCounter;
    }

    @Override
    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    @Override
    public void seal() throws ConfigurationException, IOException {
        for (InvertedIndexCreator invertedIndexCreator : this._invertedIndexCreatorMap.values()) {
            invertedIndexCreator.seal();
        }
        this.writeMetadata();
    }

    void writeMetadata() throws ConfigurationException {
        String timeColumn;
        ColumnIndexCreationInfo timeColumnIndexCreationInfo;
        PropertiesConfiguration properties = new PropertiesConfiguration(new File(this._indexDir, "metadata.properties"));
        properties.setProperty("creator.version", this.config.getCreatorVersion());
        properties.setProperty("segment.padding.character", String.valueOf('\u0000'));
        properties.setProperty("segment.name", this.segmentName);
        properties.setProperty("segment.table.name", this.config.getTableName());
        properties.setProperty("segment.dimension.column.names", this.config.getDimensions());
        properties.setProperty("segment.metric.column.names", this.config.getMetrics());
        properties.setProperty("segment.datetime.column.names", this.config.getDateTimeColumnNames());
        properties.setProperty("segment.time.column.name", this.config.getTimeColumnName());
        properties.setProperty("segment.time.interval", "not_there");
        properties.setProperty("segment.total.raw.docs", String.valueOf(this.totalRawDocs));
        properties.setProperty("segment.total.aggregate.docs", String.valueOf(this.totalAggDocs));
        properties.setProperty("segment.total.docs", String.valueOf(this.totalDocs));
        properties.setProperty("startree.enabled", String.valueOf(this.config.isEnableStarTreeIndex()));
        StarTreeIndexSpec starTreeIndexSpec = this.config.getStarTreeIndexSpec();
        if (starTreeIndexSpec != null) {
            properties.setProperty("startree.split.order", starTreeIndexSpec.getDimensionsSplitOrder());
            properties.setProperty("startree.max.leaf.records", starTreeIndexSpec.getMaxLeafRecords());
            properties.setProperty("startree.skip.star.node.creation.for.dimensions", starTreeIndexSpec.getSkipStarNodeCreationForDimensions());
            properties.setProperty("star.tree.skip.materialization.cardinality", starTreeIndexSpec.getSkipMaterializationCardinalityThreshold());
            properties.setProperty("star.tree.skip.materialization.for.dimensions", starTreeIndexSpec.getSkipMaterializationForDimensions());
        }
        HllConfig hllConfig = this.config.getHllConfig();
        Map<String, String> derivedHllFieldToOriginMap = null;
        if (hllConfig != null) {
            properties.setProperty("segment.hll.log2m", hllConfig.getHllLog2m());
            derivedHllFieldToOriginMap = hllConfig.getDerivedHllFieldToOriginMap();
        }
        if ((timeColumnIndexCreationInfo = this.indexCreationInfoMap.get(timeColumn = this.config.getTimeColumnName())) != null) {
            if (this.config.getStartTime() != null && this.config.getEndTime() != null) {
                properties.setProperty("segment.start.time", this.config.getStartTime());
                properties.setProperty("segment.end.time", this.config.getEndTime());
            } else {
                Object minTime = timeColumnIndexCreationInfo.getMin();
                Object object = timeColumnIndexCreationInfo.getMax();
                if (this.config.getTimeColumnType() == SegmentGeneratorConfig.TimeColumnType.SIMPLE_DATE) {
                    DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)this.config.getSimpleDateFormat());
                    properties.setProperty("segment.start.time", dateTimeFormatter.parseMillis(minTime.toString()));
                    properties.setProperty("segment.end.time", dateTimeFormatter.parseMillis(object.toString()));
                } else {
                    properties.setProperty("segment.start.time", minTime);
                    properties.setProperty("segment.end.time", object);
                }
            }
            properties.setProperty("segment.time.unit", (Object)this.config.getSegmentTimeUnit());
        }
        for (Map.Entry<String, String> entry : this.config.getCustomProperties().entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.indexCreationInfoMap.entrySet()) {
            String column = entry.getKey();
            ColumnIndexCreationInfo columnIndexCreationInfo = (ColumnIndexCreationInfo)entry.getValue();
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(column);
            int dictionaryElementSize = dictionaryCreator != null ? dictionaryCreator.getNumBytesPerEntry() : 0;
            boolean hasInvertedIndex = true;
            String hllOriginColumn = null;
            if (derivedHllFieldToOriginMap != null) {
                hllOriginColumn = derivedHllFieldToOriginMap.get(column);
            }
            SegmentColumnarIndexCreator.addColumnMetadataInfo(properties, column, columnIndexCreationInfo, this.totalDocs, this.totalRawDocs, this.totalAggDocs, this.schema.getFieldSpecFor(column), this._dictionaryCreatorMap.containsKey(column), dictionaryElementSize, hasInvertedIndex, hllOriginColumn);
        }
        properties.save();
    }

    public static void addColumnMetadataInfo(PropertiesConfiguration properties, String column, ColumnIndexCreationInfo columnIndexCreationInfo, int totalDocs, int totalRawDocs, int totalAggDocs, FieldSpec fieldSpec, boolean hasDictionary, int dictionaryElementSize, boolean hasInvertedIndex, String hllOriginColumn) {
        Object defaultNullValue;
        int cardinality = columnIndexCreationInfo.getDistinctValueCount();
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "cardinality"), String.valueOf(cardinality));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "totalDocs"), String.valueOf(totalDocs));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "totalRawDocs"), String.valueOf(totalRawDocs));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "totalAggDocs"), String.valueOf(totalAggDocs));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "dataType"), String.valueOf((Object)fieldSpec.getDataType()));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "bitsPerElement"), String.valueOf(PinotDataBitSet.getNumBitsPerValue(cardinality - 1)));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "lengthOfEachEntry"), String.valueOf(dictionaryElementSize));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "columnType"), String.valueOf((Object)fieldSpec.getFieldType()));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "isSorted"), String.valueOf(columnIndexCreationInfo.isSorted()));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "hasNullValue"), String.valueOf(columnIndexCreationInfo.hasNulls()));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "hasDictionary"), String.valueOf(hasDictionary));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "hasInvertedIndex"), String.valueOf(hasInvertedIndex));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "isSingleValues"), String.valueOf(fieldSpec.isSingleValueField()));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "maxNumberOfMultiValues"), String.valueOf(columnIndexCreationInfo.getMaxNumberOfMultiValueElements()));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "totalNumberOfEntries"), String.valueOf(columnIndexCreationInfo.getTotalNumberOfEntries()));
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "isAutoGenerated"), String.valueOf(columnIndexCreationInfo.isAutoGenerated()));
        PartitionFunction partitionFunction = columnIndexCreationInfo.getPartitionFunction();
        if (partitionFunction != null) {
            properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "partitionFunction"), partitionFunction.toString());
            properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "numPartitions"), columnIndexCreationInfo.getNumPartitions());
            properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "partitionValues"), columnIndexCreationInfo.getPartitions());
        }
        if (fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.DATE_TIME)) {
            DateTimeFieldSpec dateTimeFieldSpec = (DateTimeFieldSpec)fieldSpec;
            properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "datetimeFormat"), dateTimeFieldSpec.getFormat());
            properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "datetimeGranularity"), dateTimeFieldSpec.getGranularity());
        }
        if (hllOriginColumn != null) {
            properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "originColumn"), hllOriginColumn);
            properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "derivedMetricType"), "HLL");
        }
        if ((defaultNullValue = columnIndexCreationInfo.getDefaultNullValue()) == null) {
            defaultNullValue = fieldSpec.getDefaultNullValue();
        }
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "defaultNullValue"), String.valueOf(defaultNullValue));
    }

    public static void addColumnMinMaxValueInfo(PropertiesConfiguration properties, String column, String minValue, String maxValue) {
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "minValue"), minValue);
        properties.setProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "maxValue"), maxValue);
    }

    public static void removeColumnMetadataInfo(PropertiesConfiguration properties, String column) {
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "cardinality"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "totalDocs"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "totalRawDocs"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "totalAggDocs"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "dataType"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "bitsPerElement"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "lengthOfEachEntry"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "columnType"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "isSorted"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "hasNullValue"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "hasDictionary"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "hasInvertedIndex"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "isSingleValues"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "maxNumberOfMultiValues"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "totalNumberOfEntries"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "isAutoGenerated"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "defaultNullValue"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "derivedMetricType"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "originColumn"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "minValue"));
        properties.clearProperty(.V1Constants.MetadataKeys.Column.getKeyFor(column, "maxValue"));
    }

    public static SingleValueRawIndexCreator getRawIndexCreatorForColumn(File file, .ChunkCompressorFactory.CompressionType compressionType, String column, FieldSpec.DataType dataType, int totalDocs, int lengthOfLongestEntry) throws IOException {
        BaseSingleValueRawIndexCreator indexCreator;
        switch (dataType) {
            case INT: {
                indexCreator = new SingleValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, 4);
                break;
            }
            case LONG: {
                indexCreator = new SingleValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, 8);
                break;
            }
            case FLOAT: {
                indexCreator = new SingleValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, 4);
                break;
            }
            case DOUBLE: {
                indexCreator = new SingleValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, 8);
                break;
            }
            case STRING: 
            case BYTES: {
                indexCreator = new SingleValueVarByteRawIndexCreator(file, compressionType, column, totalDocs, lengthOfLongestEntry);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Data type not supported for raw indexing: " + (Object)((Object)dataType));
            }
        }
        return indexCreator;
    }

    @Override
    public void close() throws IOException {
        for (SegmentDictionaryCreator dictionaryCreator : this._dictionaryCreatorMap.values()) {
            dictionaryCreator.close();
        }
        for (ForwardIndexCreator forwardIndexCreator : this._forwardIndexCreatorMap.values()) {
            forwardIndexCreator.close();
        }
        for (InvertedIndexCreator invertedIndexCreator : this._invertedIndexCreatorMap.values()) {
            invertedIndexCreator.close();
        }
    }
}

