/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReader;
import org.apache.pinot.$internal.org.apache.pinot.core.data.readers.RecordReaderFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.CompoundTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.data.recordtransformer.RecordTransformer;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnIndexCreationInfo;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ForwardIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.InvertedIndexType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.RecordReaderSegmentCreationDataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentCreationDataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentIndexCreationDriver;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentIndexCreationInfo;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentPreIndexStatsContainer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.SegmentPreIndexStatsCollectorImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.converter.SegmentFormatConverter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.converter.SegmentFormatConverterFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.store.SegmentDirectoryPaths;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.OffHeapStarTreeBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTreeBuilderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.hll.HllUtil;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.MultipleTreesBuilder;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.util.CrcUtils;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.MetricFieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.data.StarTreeIndexSpec;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.startree.hll.HllConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentIndexCreationDriverImpl
implements SegmentIndexCreationDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentIndexCreationDriverImpl.class);
    private SegmentGeneratorConfig config;
    private RecordReader recordReader;
    private SegmentPreIndexStatsContainer segmentStats;
    private Map<String, ColumnIndexCreationInfo> indexCreationInfoMap;
    private SegmentCreator indexCreator;
    private SegmentIndexCreationInfo segmentIndexCreationInfo;
    private Schema dataSchema;
    private RecordTransformer _recordTransformer;
    private int totalDocs = 0;
    private int totalRawDocs = 0;
    private int totalAggDocs = 0;
    private File tempIndexDir;
    private String segmentName;
    private long totalRecordReadTime = 0L;
    private long totalIndexTime = 0L;
    private long totalStatsCollectorTime = 0L;
    private boolean createStarTree = false;
    private boolean createHllIndex = false;
    private File starTreeTempDir;

    @Override
    public void init(SegmentGeneratorConfig config) throws Exception {
        this.init(config, RecordReaderFactory.getRecordReader(config));
    }

    public void init(SegmentGeneratorConfig config, RecordReader recordReader) {
        this.init(config, new RecordReaderSegmentCreationDataSource(recordReader));
    }

    public void init(SegmentGeneratorConfig config, SegmentCreationDataSource dataSource) {
        this.init(config, dataSource, CompoundTransformer.getDefaultTransformer(dataSource.getRecordReader().getSchema()));
    }

    public void init(SegmentGeneratorConfig config, SegmentCreationDataSource dataSource, RecordTransformer recordTransformer) {
        HllConfig hllConfig;
        this.config = config;
        this.createStarTree = config.isEnableStarTreeIndex();
        this.recordReader = dataSource.getRecordReader();
        Preconditions.checkState(this.recordReader.hasNext(), "No record in data source");
        this.dataSchema = this.recordReader.getSchema();
        if (config.getHllConfig() != null && (hllConfig = config.getHllConfig()).getColumnsToDeriveHllFields() != null && !hllConfig.getColumnsToDeriveHllFields().isEmpty()) {
            if (!this.createStarTree) {
                throw new IllegalArgumentException("Derived HLL fields generation will not work if StarTree is not enabled.");
            }
            this.createHllIndex = true;
        }
        this.addDerivedFieldsInSchema();
        this._recordTransformer = recordTransformer;
        if (!this.createStarTree) {
            this.segmentStats = dataSource.gatherStats(new StatsCollectorConfig(this.dataSchema, config.getSegmentPartitionConfig()));
            this.totalDocs = this.segmentStats.getTotalDocCount();
            this.totalRawDocs = this.segmentStats.getRawDocCount();
            this.totalAggDocs = this.segmentStats.getAggregatedDocCount();
        }
        this.segmentIndexCreationInfo = new SegmentIndexCreationInfo();
        this.indexCreationInfoMap = new HashMap<String, ColumnIndexCreationInfo>();
        this.indexCreator = new SegmentColumnarIndexCreator();
        File indexDir = new File(config.getOutDir());
        if (!indexDir.exists()) {
            indexDir.mkdirs();
        }
        this.tempIndexDir = new File(indexDir, FileUtils.getRandomFileName());
        this.starTreeTempDir = new File(indexDir, FileUtils.getRandomFileName());
        LOGGER.debug("tempIndexDir:{}", (Object)this.tempIndexDir);
        LOGGER.debug("starTreeTempDir:{}", (Object)this.starTreeTempDir);
    }

    private void addDerivedFieldsInSchema() {
        if (this.createHllIndex) {
            Set<String> columnNames = this.dataSchema.getColumnNames();
            HllConfig hllConfig = this.config.getHllConfig();
            for (String derivedFieldName : hllConfig.getDerivedHllFieldToOriginMap().keySet()) {
                if (columnNames.contains(derivedFieldName)) {
                    throw new IllegalArgumentException("Cannot add derived field: " + derivedFieldName + " since it already exists in schema.");
                }
                this.dataSchema.addField(new MetricFieldSpec(derivedFieldName, FieldSpec.DataType.STRING, hllConfig.getHllFieldSize(), MetricFieldSpec.DerivedMetricType.HLL));
            }
        }
    }

    private void populateDefaultDerivedColumnValues(GenericRow row) throws IOException {
        if (this.createHllIndex) {
            HllConfig hllConfig = this.config.getHllConfig();
            for (Map.Entry<String, String> entry : hllConfig.getDerivedHllFieldToOriginMap().entrySet()) {
                String derivedFieldName = entry.getKey();
                String originFieldName = entry.getValue();
                row.putField(derivedFieldName, HllUtil.singleValueHllAsString(hllConfig.getHllLog2m(), row.getValue(originFieldName)));
            }
        }
    }

    @Override
    public void build() throws Exception {
        if (this.createStarTree) {
            this.buildStarTree();
        } else {
            this.buildRaw();
        }
    }

    private void buildStarTree() throws Exception {
        StatsCollectorConfig statsCollectorConfig = new StatsCollectorConfig(this.dataSchema, this.config.getSegmentPartitionConfig());
        SegmentPreIndexStatsCollectorImpl statsCollector = new SegmentPreIndexStatsCollectorImpl(statsCollectorConfig);
        statsCollector.init();
        this.segmentStats = statsCollector;
        long start = System.currentTimeMillis();
        StarTreeIndexSpec starTreeIndexSpec = this.config.getStarTreeIndexSpec();
        if (starTreeIndexSpec == null) {
            starTreeIndexSpec = new StarTreeIndexSpec();
            starTreeIndexSpec.setMaxLeafRecords(100000);
            this.config.enableStarTreeIndex(starTreeIndexSpec);
        }
        StarTreeBuilderConfig starTreeBuilderConfig = new StarTreeBuilderConfig();
        starTreeBuilderConfig.setOutDir(this.starTreeTempDir);
        starTreeBuilderConfig.setSchema(this.dataSchema);
        starTreeBuilderConfig.setDimensionsSplitOrder(starTreeIndexSpec.getDimensionsSplitOrder());
        starTreeBuilderConfig.setSkipStarNodeCreationDimensions(starTreeIndexSpec.getSkipStarNodeCreationForDimensions());
        starTreeBuilderConfig.setSkipMaterializationDimensions(starTreeIndexSpec.getSkipMaterializationForDimensions());
        starTreeBuilderConfig.setSkipMaterializationCardinalityThreshold(starTreeIndexSpec.getSkipMaterializationCardinalityThreshold());
        starTreeBuilderConfig.setMaxNumLeafRecords(starTreeIndexSpec.getMaxLeafRecords());
        starTreeBuilderConfig.setExcludeSkipMaterializationDimensionsForStarTreeIndex(starTreeIndexSpec.isExcludeSkipMaterializationDimensionsForStarTreeIndex());
        try (OffHeapStarTreeBuilder starTreeBuilder = new OffHeapStarTreeBuilder();){
            starTreeBuilder.init(starTreeBuilderConfig);
            this.recordReader.rewind();
            LOGGER.info("Start append raw data to star tree builder!");
            this.totalDocs = 0;
            GenericRow readRow = null;
            while (this.recordReader.hasNext()) {
                GenericRow transformedRow = this._recordTransformer.transform(this.recordReader.next(readRow = GenericRow.createOrReuseRow(readRow)));
                if (transformedRow == null) continue;
                this.populateDefaultDerivedColumnValues(transformedRow);
                starTreeBuilder.append(transformedRow);
                statsCollector.collectRow(transformedRow);
                ++this.totalRawDocs;
                ++this.totalDocs;
            }
            this.recordReader.close();
            LOGGER.info("Start building star tree!");
            starTreeBuilder.build();
            LOGGER.info("Finished building star tree!");
            long starTreeBuildFinishTime = System.currentTimeMillis();
            LOGGER.info("Start building StatsCollector!");
            Iterator<GenericRow> aggregatedRowsIterator = starTreeBuilder.iterator(starTreeBuilder.getTotalRawDocumentCount(), starTreeBuilder.getTotalRawDocumentCount() + starTreeBuilder.getTotalAggregateDocumentCount());
            while (aggregatedRowsIterator.hasNext()) {
                GenericRow genericRow = aggregatedRowsIterator.next();
                statsCollector.collectRow(genericRow, true);
                ++this.totalAggDocs;
                ++this.totalDocs;
            }
            statsCollector.build();
            this.buildIndexCreationInfo();
            LOGGER.info("Collected stats for {} raw documents, {} aggregated documents", (Object)this.totalRawDocs, (Object)this.totalAggDocs);
            long statCollectionFinishTime = System.currentTimeMillis();
            try {
                this.indexCreator.init(this.config, this.segmentIndexCreationInfo, this.indexCreationInfoMap, this.dataSchema, this.tempIndexDir);
                Iterator<GenericRow> allRowsIterator = starTreeBuilder.iterator(0, starTreeBuilder.getTotalRawDocumentCount() + starTreeBuilder.getTotalAggregateDocumentCount());
                while (allRowsIterator.hasNext()) {
                    GenericRow genericRow = allRowsIterator.next();
                    this.indexCreator.indexRow(genericRow);
                }
            }
            catch (Exception e) {
                this.indexCreator.close();
                throw e;
            }
            starTreeBuilder.serializeTree(new File(this.tempIndexDir, "star-tree.bin"), this.indexCreationInfoMap);
            starTreeIndexSpec.setDimensionsSplitOrder(starTreeBuilder.getDimensionsSplitOrder());
            starTreeIndexSpec.setSkipMaterializationForDimensions(starTreeBuilder.getSkipMaterializationDimensions());
            this.handlePostCreation();
            long end = System.currentTimeMillis();
            LOGGER.info("Total time:{} \n star tree build time:{} \n stat collection time:{} \n column index build time:{}", new Object[]{end - start, starTreeBuildFinishTime - start, statCollectionFinishTime - starTreeBuildFinishTime, end - statCollectionFinishTime});
        }
    }

    private void buildRaw() throws Exception {
        LOGGER.debug("Start building StatsCollector!");
        this.buildIndexCreationInfo();
        LOGGER.info("Finished building StatsCollector!");
        LOGGER.info("Collected stats for {} documents", (Object)this.totalDocs);
        try {
            this.indexCreator.init(this.config, this.segmentIndexCreationInfo, this.indexCreationInfoMap, this.dataSchema, this.tempIndexDir);
            this.recordReader.rewind();
            LOGGER.info("Start building IndexCreator!");
            GenericRow readRow = null;
            while (this.recordReader.hasNext()) {
                long start = System.currentTimeMillis();
                readRow = GenericRow.createOrReuseRow(readRow);
                GenericRow transformedRow = this._recordTransformer.transform(this.recordReader.next(readRow));
                long stop = System.currentTimeMillis();
                this.totalRecordReadTime += stop - start;
                if (transformedRow == null) continue;
                this.indexCreator.indexRow(transformedRow);
                long stop1 = System.currentTimeMillis();
                this.totalIndexTime += stop1 - stop;
            }
        }
        catch (Exception e) {
            this.indexCreator.close();
            throw e;
        }
        finally {
            this.recordReader.close();
        }
        LOGGER.info("Finished records indexing in IndexCreator!");
        this.handlePostCreation();
    }

    private void handlePostCreation() throws Exception {
        long creationTime;
        ColumnStatistics timeColumnStatistics = this.segmentStats.getColumnProfileFor(this.config.getTimeColumnName());
        int sequenceId = this.config.getSequenceId();
        this.segmentName = timeColumnStatistics != null ? this.config.getSegmentNameGenerator().generateSegmentName(sequenceId, timeColumnStatistics.getMinValue(), timeColumnStatistics.getMaxValue()) : this.config.getSegmentNameGenerator().generateSegmentName(sequenceId, null, null);
        try {
            this.indexCreator.setSegmentName(this.segmentName);
            this.indexCreator.seal();
        }
        finally {
            this.indexCreator.close();
        }
        LOGGER.info("Finished segment seal!");
        File outputDir = new File(this.config.getOutDir());
        File segmentOutputDir = new File(outputDir, this.segmentName);
        if (segmentOutputDir.exists()) {
            org.apache.pinot.$internal.org.apache.commons.io.FileUtils.deleteDirectory(segmentOutputDir);
        }
        org.apache.pinot.$internal.org.apache.commons.io.FileUtils.moveDirectory(this.tempIndexDir, segmentOutputDir);
        org.apache.pinot.$internal.org.apache.commons.io.FileUtils.deleteQuietly(this.tempIndexDir);
        this.convertFormatIfNeeded(segmentOutputDir);
        this.buildStarTreeV2IfNecessary(segmentOutputDir);
        long crc = CrcUtils.forAllFilesInFolder(segmentOutputDir).computeCrc();
        String creationTimeInConfig = this.config.getCreationTime();
        if (creationTimeInConfig != null) {
            try {
                creationTime = Long.parseLong(creationTimeInConfig);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while parsing creation time in config, use current time as creation time");
                creationTime = System.currentTimeMillis();
            }
        } else {
            creationTime = System.currentTimeMillis();
        }
        SegmentIndexCreationDriverImpl.persistCreationMeta(segmentOutputDir, crc, creationTime);
        LOGGER.info("Driver, record read time : {}", (Object)this.totalRecordReadTime);
        LOGGER.info("Driver, stats collector time : {}", (Object)this.totalStatsCollectorTime);
        LOGGER.info("Driver, indexing time : {}", (Object)this.totalIndexTime);
    }

    private void buildStarTreeV2IfNecessary(File indexDir) throws Exception {
        List<StarTreeV2BuilderConfig> starTreeV2BuilderConfigs = this.config.getStarTreeV2BuilderConfigs();
        if (starTreeV2BuilderConfigs != null && !starTreeV2BuilderConfigs.isEmpty()) {
            MultipleTreesBuilder.BuildMode buildMode = this.config.isOnHeap() ? MultipleTreesBuilder.BuildMode.ON_HEAP : MultipleTreesBuilder.BuildMode.OFF_HEAP;
            new MultipleTreesBuilder(starTreeV2BuilderConfigs, indexDir, buildMode).build();
        }
    }

    private void convertFormatIfNeeded(File segmentDirectory) throws Exception {
        SegmentVersion versionToGenerate = this.config.getSegmentVersion();
        if (versionToGenerate.equals((Object)SegmentVersion.v1)) {
            return;
        }
        SegmentFormatConverter converter = SegmentFormatConverterFactory.getConverter(SegmentVersion.v1, SegmentVersion.v3);
        converter.convert(segmentDirectory);
    }

    @Override
    public ColumnStatistics getColumnStatisticsCollector(String columnName) throws Exception {
        return this.segmentStats.getColumnProfileFor(columnName);
    }

    public static void persistCreationMeta(File indexDir, long crc, long creationTime) throws IOException {
        File segmentDir = SegmentDirectoryPaths.findSegmentDirectory(indexDir);
        File creationMetaFile = new File(segmentDir, "creation.meta");
        try (DataOutputStream output = new DataOutputStream(new FileOutputStream(creationMetaFile));){
            output.writeLong(crc);
            output.writeLong(creationTime);
        }
    }

    void buildIndexCreationInfo() throws Exception {
        for (FieldSpec spec : this.dataSchema.getAllFieldSpecs()) {
            String column = spec.getName();
            if (this.dataSchema.isVirtualColumn(column)) continue;
            ColumnStatistics columnProfile = this.segmentStats.getColumnProfileFor(column);
            this.indexCreationInfoMap.put(column, new ColumnIndexCreationInfo(columnProfile, true, ForwardIndexType.FIXED_BIT_COMPRESSED, InvertedIndexType.ROARING_BITMAPS, false, this.dataSchema.getFieldSpecFor(column).getDefaultNullValue()));
        }
        this.segmentIndexCreationInfo.setTotalDocs(this.totalDocs);
        this.segmentIndexCreationInfo.setTotalRawDocs(this.totalRawDocs);
        this.segmentIndexCreationInfo.setTotalAggDocs(this.totalAggDocs);
        this.segmentIndexCreationInfo.setStarTreeEnabled(this.createStarTree);
    }

    @Override
    public String getSegmentName() {
        return this.segmentName;
    }

    @Override
    public File getOutputDirectory() {
        return new File(new File(this.config.getOutDir()), this.segmentName);
    }

    public SegmentPreIndexStatsContainer getSegmentStats() {
        return this.segmentStats;
    }
}

