/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.v1.FixedByteChunkSingleValueWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.BaseSingleValueRawIndexCreator;

public class SingleValueFixedByteRawIndexCreator
extends BaseSingleValueRawIndexCreator {
    private static final int NUM_DOCS_PER_CHUNK = 1000;
    final FixedByteChunkSingleValueWriter _indexWriter;

    public SingleValueFixedByteRawIndexCreator(File baseIndexDir, .ChunkCompressorFactory.CompressionType compressionType, String column, int totalDocs, int sizeOfEntry) throws IOException {
        File file = new File(baseIndexDir, column + ".sv.raw.fwd");
        this._indexWriter = new FixedByteChunkSingleValueWriter(file, compressionType, totalDocs, 1000, sizeOfEntry);
    }

    @Override
    public void index(int docId, int valueToIndex) {
        this._indexWriter.setInt(docId, valueToIndex);
    }

    @Override
    public void index(int docId, long valueToIndex) {
        this._indexWriter.setLong(docId, valueToIndex);
    }

    @Override
    public void index(int docId, float valueToIndex) {
        this._indexWriter.setFloat(docId, valueToIndex);
    }

    @Override
    public void index(int docId, double valueToIndex) {
        this._indexWriter.setDouble(docId, valueToIndex);
    }

    @Override
    public void index(int docId, Object valueToIndex) {
        if (valueToIndex instanceof Integer) {
            this.index(docId, (Integer)valueToIndex);
        } else if (valueToIndex instanceof Long) {
            this.index(docId, (Long)valueToIndex);
        } else if (valueToIndex instanceof Float) {
            this.index(docId, ((Float)valueToIndex).floatValue());
        } else if (valueToIndex instanceof Double) {
            this.index(docId, (Double)valueToIndex);
        } else {
            throw new IllegalArgumentException("Illegal argument type for fixed length raw indexing: " + valueToIndex.getClass().getName());
        }
    }

    @Override
    public void close() throws IOException {
        this._indexWriter.close();
    }
}

