/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.io.writer.impl.v1.VarByteChunkSingleValueWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.BaseSingleValueRawIndexCreator;

public class SingleValueVarByteRawIndexCreator
extends BaseSingleValueRawIndexCreator {
    private static final int NUM_DOCS_PER_CHUNK = 1000;
    private final VarByteChunkSingleValueWriter _indexWriter;

    public SingleValueVarByteRawIndexCreator(File baseIndexDir, .ChunkCompressorFactory.CompressionType compressionType, String column, int totalDocs, int maxLength) throws IOException {
        File file = new File(baseIndexDir, column + ".sv.raw.fwd");
        this._indexWriter = new VarByteChunkSingleValueWriter(file, compressionType, totalDocs, 1000, maxLength);
    }

    @Override
    public void index(int docId, String valueToIndex) {
        this._indexWriter.setString(docId, valueToIndex);
    }

    @Override
    public void index(int docId, byte[] valueToIndex) {
        this._indexWriter.setBytes(docId, valueToIndex);
    }

    @Override
    public void index(int docId, Object valueToIndex) {
        if (valueToIndex instanceof String) {
            this._indexWriter.setString(docId, (String)valueToIndex);
        } else if (valueToIndex instanceof byte[]) {
            this._indexWriter.setBytes(docId, (byte[])valueToIndex);
        } else {
            throw new IllegalArgumentException("Illegal data type for variable length indexing: " + valueToIndex.getClass().getName());
        }
    }

    @Override
    public void close() throws IOException {
        this._indexWriter.close();
    }
}

