/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.AbstractColumnStatisticsCollector;

public class LongColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private Long min = null;
    private Long max = null;
    private final LongSet rawLongSet = new LongOpenHashSet(1000);
    private final LongSet aggregatedLongSet = new LongOpenHashSet(1000);
    private long[] sortedLongList;
    private boolean sealed = false;

    public LongColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    private void collectEntry(Object entry, LongSet set) {
        if (entry instanceof Object[]) {
            for (Object e : (Object[])entry) {
                set.add(((Number)e).longValue());
            }
            if (this.maxNumberOfMultiValues < ((Object[])entry).length) {
                this.maxNumberOfMultiValues = ((Object[])entry).length;
            }
            this.updateTotalNumberOfEntries((Object[])entry);
        } else {
            long value = ((Number)entry).longValue();
            this.addressSorted(value);
            this.updatePartition(value);
            set.add(value);
            ++this.totalNumberOfEntries;
        }
    }

    @Override
    public void collect(Object entry, boolean isAggregated) {
        if (isAggregated) {
            this.collectEntry(entry, this.aggregatedLongSet);
        } else {
            this.collectEntry(entry, this.rawLongSet);
        }
    }

    @Override
    public void collect(Object entry) {
        this.collect(entry, false);
    }

    @Override
    public Long getMinValue() {
        if (this.sealed) {
            return this.min;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Long getMaxValue() {
        if (this.sealed) {
            return this.max;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Object getUniqueValuesSet() {
        if (this.sealed) {
            return this.sortedLongList;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public int getCardinality() {
        if (this.sealed) {
            return this.sortedLongList.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this.sealed = true;
        this.sortedLongList = new long[this.rawLongSet.size()];
        this.rawLongSet.toArray(this.sortedLongList);
        Arrays.sort(this.sortedLongList);
        if (this.sortedLongList.length == 0) {
            this.min = null;
            this.max = null;
            return;
        }
        this.min = this.sortedLongList[0];
        this.max = this.sortedLongList[this.sortedLongList.length - 1];
        int numAggregated = this.aggregatedLongSet.size();
        if (numAggregated > 0) {
            this.rawLongSet.addAll((LongCollection)this.aggregatedLongSet);
            this.sortedLongList = new long[this.rawLongSet.size()];
            this.rawLongSet.toArray(this.sortedLongList);
            Arrays.sort(this.sortedLongList);
        }
    }
}

