/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.ColumnStatistics;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.SegmentPreIndexStatsCollector;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.BytesColumnPredIndexStatsCollector;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.DoubleColumnPreIndexStatsCollector;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.FloatColumnPreIndexStatsCollector;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.IntColumnPreIndexStatsCollector;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.LongColumnPreIndexStatsCollector;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.StringColumnPreIndexStatsCollector;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPreIndexStatsCollectorImpl
implements SegmentPreIndexStatsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPreIndexStatsCollectorImpl.class);
    private final StatsCollectorConfig _statsCollectorConfig;
    private Map<String, AbstractColumnStatisticsCollector> columnStatsCollectorMap;
    private int rawDocCount;
    private int aggregatedDocCount;
    private int totalDocCount;

    public SegmentPreIndexStatsCollectorImpl(StatsCollectorConfig statsCollectorConfig) {
        this._statsCollectorConfig = statsCollectorConfig;
    }

    @Override
    public void init() {
        this.columnStatsCollectorMap = new HashMap<String, AbstractColumnStatisticsCollector>();
        Schema dataSchema = this._statsCollectorConfig.getSchema();
        for (FieldSpec spec : dataSchema.getAllFieldSpecs()) {
            String column = spec.getName();
            switch (spec.getDataType()) {
                case BOOLEAN: 
                case STRING: {
                    this.columnStatsCollectorMap.put(spec.getName(), new StringColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    break;
                }
                case INT: {
                    this.columnStatsCollectorMap.put(spec.getName(), new IntColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    break;
                }
                case LONG: {
                    this.columnStatsCollectorMap.put(spec.getName(), new LongColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    break;
                }
                case FLOAT: {
                    this.columnStatsCollectorMap.put(spec.getName(), new FloatColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    break;
                }
                case DOUBLE: {
                    this.columnStatsCollectorMap.put(spec.getName(), new DoubleColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    break;
                }
                case BYTES: {
                    this.columnStatsCollectorMap.put(spec.getName(), new BytesColumnPredIndexStatsCollector(column, this._statsCollectorConfig));
                    break;
                }
            }
        }
    }

    @Override
    public void build() {
        for (String column : this.columnStatsCollectorMap.keySet()) {
            this.columnStatsCollectorMap.get(column).seal();
        }
    }

    @Override
    public ColumnStatistics getColumnProfileFor(String column) {
        return this.columnStatsCollectorMap.get(column);
    }

    @Override
    public void collectRow(GenericRow row) throws Exception {
        this.collectRow(row, false);
    }

    @Override
    public void collectRow(GenericRow row, boolean isAggregated) throws Exception {
        for (Map.Entry<String, Object> columnNameAndValue : row.getEntrySet()) {
            String columnName = columnNameAndValue.getKey();
            Object value = columnNameAndValue.getValue();
            if (!this.columnStatsCollectorMap.containsKey(columnName)) continue;
            try {
                this.columnStatsCollectorMap.get(columnName).collect(value, isAggregated);
            }
            catch (Exception e) {
                LOGGER.error("Exception while collecting stats for column:{} in row:{}", (Object)columnName, (Object)row);
                throw e;
            }
        }
        ++this.totalDocCount;
        if (!isAggregated) {
            ++this.rawDocCount;
        } else {
            ++this.aggregatedDocCount;
        }
    }

    @Override
    public int getRawDocCount() {
        return this.rawDocCount;
    }

    @Override
    public int getAggregatedDocCount() {
        return this.aggregatedDocCount;
    }

    @Override
    public int getTotalDocCount() {
        return this.totalDocCount;
    }

    @Override
    public void logStats() {
        try {
            for (String column : this.columnStatsCollectorMap.keySet()) {
                AbstractColumnStatisticsCollector statisticsCollector = this.columnStatsCollectorMap.get(column);
                LOGGER.info("********** logging for column : " + column + " ********************* ");
                LOGGER.info("min value : " + statisticsCollector.getMinValue());
                LOGGER.info("max value : " + statisticsCollector.getMaxValue());
                LOGGER.info("cardinality : " + statisticsCollector.getCardinality());
                LOGGER.info("length of largest column : " + statisticsCollector.getLengthOfLargestElement());
                LOGGER.info("is sorted : " + statisticsCollector.isSorted());
                LOGGER.info("column type : " + (Object)((Object)this._statsCollectorConfig.getSchema().getFieldSpecFor(column).getDataType()));
                if (statisticsCollector.getPartitionFunction() != null) {
                    LOGGER.info("partitions: " + statisticsCollector.getPartitions().toString());
                }
                LOGGER.info("***********************************************");
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while logging column stats", (Throwable)e);
        }
    }
}

