/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.common.utils.StringUtil;

public class StringColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private String min = "nil";
    private String max = "nil";
    private int smallestStringLength = Integer.MAX_VALUE;
    private int longestStringLength = 0;
    private final ObjectSet<String> rawStringSet = new ObjectOpenHashSet(1000);
    private final ObjectSet<String> aggregatedStringSet = new ObjectOpenHashSet(1000);
    private String[] sortedStringList;
    private boolean sealed = false;

    public StringColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    private void collectEntry(Object entry, ObjectSet<String> set) {
        if (entry instanceof Object[]) {
            for (Object e : (Object[])entry) {
                String value = e.toString();
                set.add((Object)value);
                int valueLength = StringUtil.encodeUtf8(value).length;
                this.smallestStringLength = Math.min(this.smallestStringLength, valueLength);
                this.longestStringLength = Math.max(this.longestStringLength, valueLength);
            }
            if (this.maxNumberOfMultiValues < ((Object[])entry).length) {
                this.maxNumberOfMultiValues = ((Object[])entry).length;
            }
            this.updateTotalNumberOfEntries((Object[])entry);
        } else {
            String value = entry != null ? entry.toString() : this.fieldSpec.getDefaultNullValue().toString();
            this.addressSorted(value);
            this.updatePartition(value);
            set.add((Object)value);
            int valueLength = StringUtil.encodeUtf8(value).length;
            this.smallestStringLength = Math.min(this.smallestStringLength, valueLength);
            this.longestStringLength = Math.max(this.longestStringLength, valueLength);
            ++this.totalNumberOfEntries;
        }
    }

    @Override
    public void collect(Object entry, boolean isAggregated) {
        if (isAggregated) {
            this.collectEntry(entry, this.aggregatedStringSet);
        } else {
            this.collectEntry(entry, this.rawStringSet);
        }
    }

    @Override
    public void collect(Object entry) {
        this.collect(entry, false);
    }

    @Override
    public String getMinValue() {
        if (this.sealed) {
            return this.min;
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public String getMaxValue() {
        if (this.sealed) {
            return this.max;
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public Object[] getUniqueValuesSet() {
        if (this.sealed) {
            return this.sortedStringList;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getLengthOfLargestElement() {
        if (this.sealed) {
            return this.longestStringLength;
        }
        throw new IllegalStateException("you must seal the collector first before asking for longest value");
    }

    @Override
    public int getCardinality() {
        if (this.sealed) {
            return this.sortedStringList.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this.sealed = true;
        this.sortedStringList = new String[this.rawStringSet.size()];
        this.rawStringSet.toArray((Object[])this.sortedStringList);
        Arrays.sort(this.sortedStringList);
        if (this.sortedStringList.length == 0) {
            this.min = null;
            this.max = null;
            return;
        }
        this.min = this.sortedStringList[0];
        this.max = this.sortedStringList[this.sortedStringList.length - 1];
        int numAggregated = this.aggregatedStringSet.size();
        if (numAggregated > 0) {
            this.rawStringSet.addAll(this.aggregatedStringSet);
            this.sortedStringList = new String[this.rawStringSet.size()];
            this.rawStringSet.toArray((Object[])this.sortedStringList);
            Arrays.sort(this.sortedStringList);
        }
    }
}

