/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.data.source;

import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.common.Block;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.DataFileReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnMultiValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.SingleColumnSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.SortedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.MultiValueBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.operator.blocks.SingleValueBlock;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.MutableDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.common.data.FieldSpec;

public final class ColumnDataSource
extends DataSource {
    private final String _operatorName;
    private final FieldSpec.DataType _dataType;
    private final boolean _isSingleValue;
    private final boolean _isSorted;
    private final int _numDocs;
    private final int _maxNumMultiValues;
    private final DataFileReader _forwardIndex;
    private final InvertedIndexReader _invertedIndex;
    private final Dictionary _dictionary;
    private final BloomFilterReader _bloomFilter;
    private final int _cardinality;
    private final DataSourceMetadata _metadata;

    public ColumnDataSource(ColumnIndexContainer indexContainer, ColumnMetadata metadata) {
        this(metadata.getColumnName(), metadata.getDataType(), metadata.isSingleValue(), metadata.isSorted(), metadata.getTotalDocs(), metadata.getMaxNumberOfMultiValues(), indexContainer.getForwardIndex(), indexContainer.getInvertedIndex(), indexContainer.getDictionary(), indexContainer.getBloomFilter(), metadata.getCardinality());
    }

    public ColumnDataSource(FieldSpec fieldSpec, int numDocs, int maxNumMultiValues, DataFileReader forwardIndex, InvertedIndexReader invertedIndex, MutableDictionary dictionary, BloomFilterReader bloomFilter) {
        this(fieldSpec.getName(), fieldSpec.getDataType(), fieldSpec.isSingleValueField(), false, numDocs, maxNumMultiValues, forwardIndex, invertedIndex, dictionary, bloomFilter, Integer.MIN_VALUE);
    }

    private ColumnDataSource(String columnName, FieldSpec.DataType dataType, boolean isSingleValue, boolean isSorted, int numDocs, int maxNumMultiValues, DataFileReader forwardIndex, InvertedIndexReader invertedIndex, Dictionary dictionary, BloomFilterReader bloomFilterReader, int cardinality) {
        if (isSingleValue) {
            Preconditions.checkState(forwardIndex instanceof SingleColumnSingleValueReader);
        } else {
            Preconditions.checkState(forwardIndex instanceof SingleColumnMultiValueReader);
        }
        if (dictionary != null) {
            if (isSorted) {
                Preconditions.checkState(invertedIndex instanceof SortedIndexReader);
            }
        } else {
            Preconditions.checkState(invertedIndex == null);
        }
        this._operatorName = "ColumnDataSource [" + columnName + "]";
        this._dataType = dataType;
        this._isSingleValue = isSingleValue;
        this._isSorted = isSorted;
        this._numDocs = numDocs;
        this._maxNumMultiValues = maxNumMultiValues;
        this._forwardIndex = forwardIndex;
        this._invertedIndex = invertedIndex;
        this._dictionary = dictionary;
        this._bloomFilter = bloomFilterReader;
        this._cardinality = cardinality;
        this._metadata = new DataSourceMetadata(){

            @Override
            public FieldSpec.DataType getDataType() {
                return ColumnDataSource.this._dataType;
            }

            @Override
            public boolean isSingleValue() {
                return ColumnDataSource.this._isSingleValue;
            }

            @Override
            public boolean isSorted() {
                return ColumnDataSource.this._isSorted;
            }

            @Override
            public int getNumDocs() {
                return ColumnDataSource.this._numDocs;
            }

            @Override
            public int getMaxNumMultiValues() {
                return ColumnDataSource.this._maxNumMultiValues;
            }

            @Override
            public boolean hasInvertedIndex() {
                return ColumnDataSource.this._invertedIndex != null;
            }

            @Override
            public boolean hasDictionary() {
                return ColumnDataSource.this._dictionary != null;
            }

            @Override
            public int getCardinality() {
                return ColumnDataSource.this._cardinality;
            }
        };
    }

    @Override
    public DataSourceMetadata getDataSourceMetadata() {
        return this._metadata;
    }

    @Override
    public InvertedIndexReader getInvertedIndex() {
        return this._invertedIndex;
    }

    @Override
    public Dictionary getDictionary() {
        return this._dictionary;
    }

    @Override
    public BloomFilterReader getBloomFilter() {
        return this._bloomFilter;
    }

    protected Block getNextBlock() {
        if (this._isSingleValue) {
            return new SingleValueBlock((SingleColumnSingleValueReader)this._forwardIndex, this._numDocs, this._dataType, this._dictionary);
        }
        return new MultiValueBlock((SingleColumnMultiValueReader)this._forwardIndex, this._numDocs, this._maxNumMultiValues, this._dataType, this._dictionary);
    }

    @Override
    public String getOperatorName() {
        return this._operatorName;
    }
}

