/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.pinot.$internal.org.apache.pinot.core.bloom.BloomFilter;
import org.apache.pinot.$internal.org.apache.pinot.core.bloom.BloomFilterType;
import org.apache.pinot.$internal.org.apache.pinot.core.bloom.SegmentBloomFilterFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class BloomFilterReader {
    private BloomFilter _bloomFilter;

    public BloomFilterReader(PinotDataBuffer bloomFilterBuffer) throws IOException {
        byte[] buffer = new byte[(int)bloomFilterBuffer.size()];
        bloomFilterBuffer.copyTo(0L, buffer);
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));){
            BloomFilterType bloomFilterType = BloomFilterType.valueOf(in.readInt());
            int version = in.readInt();
            this._bloomFilter = SegmentBloomFilterFactory.createSegmentBloomFilter(bloomFilterType);
            if (version != this._bloomFilter.getVersion()) {
                throw new IOException("Unexpected bloom filter version (type: " + bloomFilterType.toString() + ", version: " + version);
            }
            this._bloomFilter.readFrom(in);
        }
    }

    public boolean mightContain(Object key) {
        return this._bloomFilter.mightContain(key.toString());
    }
}

