/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.ImmutableDictionaryReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class BytesDictionary
extends ImmutableDictionaryReader {
    public BytesDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue) {
        super(dataBuffer, length, numBytesPerValue, (byte)0);
    }

    @Override
    public int indexOf(Object rawValue) {
        int index = this.insertionIndexOf(rawValue);
        return index >= 0 ? index : -1;
    }

    @Override
    public int insertionIndexOf(Object rawValue) {
        return this.binarySearch((byte[])rawValue);
    }

    public byte[] get(int dictId) {
        return this.getBytes(dictId, this.getBuffer());
    }

    @Override
    public byte[] getBytesValue(int dictId) {
        return this.getBytes(dictId, this.getBuffer());
    }

    @Override
    public void readBytesValues(int[] dictIds, int inStartPos, int length, byte[][] outValues, int outStartPos) {
        int inEndPos = inStartPos + length;
        for (int i = inStartPos; i < inEndPos; ++i) {
            outValues[outStartPos++] = this.getBytes(dictIds[i], this.getBuffer());
        }
    }
}

