/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import java.io.IOException;
import java.util.Arrays;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.ValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.BaseDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.primitive.ByteArray;

public abstract class ImmutableDictionaryReader
extends BaseDictionary {
    private final ValueReader _valueReader;
    private final int _length;
    private final int _numBytesPerValue;
    private final byte _paddingByte;

    protected ImmutableDictionaryReader(PinotDataBuffer dataBuffer, int length, int numBytesPerValue, byte paddingByte) {
        Preconditions.checkState(dataBuffer.size() == (long)(length * numBytesPerValue));
        this._valueReader = new FixedByteValueReaderWriter(dataBuffer);
        this._length = length;
        this._numBytesPerValue = numBytesPerValue;
        this._paddingByte = paddingByte;
    }

    protected ImmutableDictionaryReader(ValueReader valueReader, int length) {
        this._valueReader = valueReader;
        this._length = length;
        this._numBytesPerValue = -1;
        this._paddingByte = 0;
    }

    public abstract int insertionIndexOf(Object var1);

    @Override
    public int length() {
        return this._length;
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this._valueReader.close();
    }

    protected int binarySearch(int value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midValue = this._valueReader.getInt(mid);
            if (midValue < value) {
                low = mid + 1;
                continue;
            }
            if (midValue > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(long value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midValue = this._valueReader.getLong(mid);
            if (midValue < value) {
                low = mid + 1;
                continue;
            }
            if (midValue > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(float value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            float midValue = this._valueReader.getFloat(mid);
            if (midValue < value) {
                low = mid + 1;
                continue;
            }
            if (midValue > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(double value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            double midValue = this._valueReader.getDouble(mid);
            if (midValue < value) {
                low = mid + 1;
                continue;
            }
            if (midValue > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(String value) {
        byte[] buffer = this.getBuffer();
        int low = 0;
        int high = this._length - 1;
        if (this._paddingByte == 0) {
            while (low <= high) {
                int mid = low + high >>> 1;
                String midValue = this._valueReader.getUnpaddedString(mid, this._numBytesPerValue, this._paddingByte, buffer);
                int compareResult = midValue.compareTo(value);
                if (compareResult < 0) {
                    low = mid + 1;
                    continue;
                }
                if (compareResult > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
        } else {
            String paddedValue = this.padString(value);
            while (low <= high) {
                int mid = low + high >>> 1;
                String midValue = this._valueReader.getPaddedString(mid, this._numBytesPerValue, buffer);
                int compareResult = midValue.compareTo(paddedValue);
                if (compareResult < 0) {
                    low = mid + 1;
                    continue;
                }
                if (compareResult > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
        }
        return -(low + 1);
    }

    protected int binarySearch(byte[] value) {
        byte[] buffer = this.getBuffer();
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte[] midValue = this._valueReader.getBytes(mid, this._numBytesPerValue, buffer);
            int compareResult = ByteArray.compare(midValue, value);
            if (compareResult < 0) {
                low = mid + 1;
                continue;
            }
            if (compareResult > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected String padString(String value) {
        String paddedValue;
        byte[] valueBytes = StringUtil.encodeUtf8(value);
        int length = valueBytes.length;
        if (length >= this._numBytesPerValue) {
            paddedValue = value;
        } else {
            byte[] paddedValueBytes = new byte[this._numBytesPerValue];
            System.arraycopy(valueBytes, 0, paddedValueBytes, 0, length);
            Arrays.fill(paddedValueBytes, length, this._numBytesPerValue, this._paddingByte);
            paddedValue = StringUtil.decodeUtf8(paddedValueBytes);
        }
        return paddedValue;
    }

    protected int getInt(int dictId) {
        return this._valueReader.getInt(dictId);
    }

    protected long getLong(int dictId) {
        return this._valueReader.getLong(dictId);
    }

    protected float getFloat(int dictId) {
        return this._valueReader.getFloat(dictId);
    }

    protected double getDouble(int dictId) {
        return this._valueReader.getDouble(dictId);
    }

    protected String getUnpaddedString(int dictId, byte[] buffer) {
        return this._valueReader.getUnpaddedString(dictId, this._numBytesPerValue, this._paddingByte, buffer);
    }

    protected String getPaddedString(int dictId, byte[] buffer) {
        return this._valueReader.getPaddedString(dictId, this._numBytesPerValue, buffer);
    }

    protected byte[] getBytes(int dictId, byte[] buffer) {
        return this._valueReader.getBytes(dictId, this._numBytesPerValue, buffer);
    }

    protected byte[] getBuffer() {
        return new byte[this._numBytesPerValue];
    }
}

