/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.ImmutableDictionaryReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class LongDictionary
extends ImmutableDictionaryReader {
    public LongDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8, (byte)0);
    }

    @Override
    public int indexOf(Object rawValue) {
        int index = this.insertionIndexOf(rawValue);
        return index >= 0 ? index : -1;
    }

    @Override
    public int insertionIndexOf(Object rawValue) {
        long value = rawValue instanceof String ? Long.parseLong((String)rawValue) : (Long)rawValue;
        return this.binarySearch(value);
    }

    @Override
    public Long get(int dictId) {
        return this.getLong(dictId);
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this.getLong(dictId);
    }

    @Override
    public long getLongValue(int dictId) {
        return this.getLong(dictId);
    }

    @Override
    public float getFloatValue(int dictId) {
        return this.getLong(dictId);
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this.getLong(dictId);
    }

    @Override
    public String getStringValue(int dictId) {
        return Long.toString(this.getLong(dictId));
    }
}

