/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Arrays;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.OnHeapDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class OnHeapIntDictionary
extends OnHeapDictionary {
    private final Int2IntOpenHashMap _valToDictId;
    private final int[] _dictIdToVal;

    public OnHeapIntDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 4, (byte)0);
        this._valToDictId = new Int2IntOpenHashMap(length);
        this._valToDictId.defaultReturnValue(-1);
        this._dictIdToVal = new int[length];
        for (int dictId = 0; dictId < length; ++dictId) {
            int value;
            this._dictIdToVal[dictId] = value = this.getInt(dictId);
            this._valToDictId.put(value, dictId);
        }
    }

    @Override
    public int indexOf(Object rawValue) {
        int value = this.getValue(rawValue);
        return this._valToDictId.get(value);
    }

    private int getValue(Object rawValue) {
        int value;
        if (rawValue instanceof String) {
            value = Integer.parseInt((String)rawValue);
        } else if (rawValue instanceof Integer) {
            value = (Integer)rawValue;
        } else {
            throw new IllegalArgumentException("Illegal data type for argument, actual: " + rawValue.getClass().getName() + " expected: " + Integer.class.getName());
        }
        return value;
    }

    @Override
    public int insertionIndexOf(Object rawValue) {
        int index = this.indexOf(rawValue);
        return index != -1 ? index : Arrays.binarySearch(this._dictIdToVal, this.getValue(rawValue));
    }

    @Override
    public Integer get(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public int getIntValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public long getLongValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public float getFloatValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public String getStringValue(int dictId) {
        return Integer.toString(this._dictIdToVal[dictId]);
    }
}

