/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.OnHeapDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class OnHeapStringDictionary
extends OnHeapDictionary {
    private final byte _paddingByte;
    private final String[] _unpaddedStrings;
    private final String[] _paddedStrings;
    private final Map<String, Integer> _paddedStringToIdMap;
    private final Map<String, Integer> _unPaddedStringToIdMap;

    public OnHeapStringDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue, byte paddingByte) {
        super(dataBuffer, length, numBytesPerValue, paddingByte);
        int i;
        this._paddingByte = paddingByte;
        byte[] buffer = new byte[numBytesPerValue];
        this._unpaddedStrings = new String[length];
        this._unPaddedStringToIdMap = new HashMap<String, Integer>(length);
        for (i = 0; i < length; ++i) {
            this._unpaddedStrings[i] = this.getUnpaddedString(i, buffer);
            this._unPaddedStringToIdMap.put(this._unpaddedStrings[i], i);
        }
        if (paddingByte == 0) {
            this._paddedStrings = null;
            this._paddedStringToIdMap = null;
        } else {
            this._paddedStrings = new String[length];
            this._paddedStringToIdMap = new HashMap<String, Integer>(length);
            for (i = 0; i < length; ++i) {
                this._paddedStrings[i] = this.getPaddedString(i, buffer);
                this._paddedStringToIdMap.put(this._paddedStrings[i], i);
            }
        }
    }

    @Override
    public int indexOf(Object rawValue) {
        Map<String, Integer> stringToIdMap = this._paddingByte == 0 ? this._unPaddedStringToIdMap : this._paddedStringToIdMap;
        Integer index = stringToIdMap.get(rawValue);
        return index != null ? index : -1;
    }

    @Override
    public int insertionIndexOf(Object rawValue) {
        if (this._paddingByte == 0) {
            Integer id = this._unPaddedStringToIdMap.get(rawValue);
            return id != null ? id : Arrays.binarySearch(this._unpaddedStrings, rawValue);
        }
        String paddedValue = this.padString((String)rawValue);
        return Arrays.binarySearch(this._paddedStrings, paddedValue);
    }

    @Override
    public String get(int dictId) {
        return this._unpaddedStrings[dictId];
    }

    @Override
    public String getStringValue(int dictId) {
        return this._unpaddedStrings[dictId];
    }
}

