/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.name;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.name.SegmentNameGenerator;
import org.apache.pinot.common.data.TimeGranularitySpec;

public class NormalizedDateSegmentNameGenerator
implements SegmentNameGenerator {
    private final String _segmentNamePrefix;
    private final boolean _appendPushType;
    private final boolean _excludeSequenceId;
    private final SimpleDateFormat _outputSDF;
    private final TimeUnit _inputTimeUnit;
    private final SimpleDateFormat _inputSDF;

    public NormalizedDateSegmentNameGenerator(String tableName, @Nullable String segmentNamePrefix, @Nullable String excludeSequenceId, @Nullable String pushType, @Nullable String pushFrequency, @Nullable String timeType, @Nullable String timeFormat) {
        this._segmentNamePrefix = segmentNamePrefix != null ? segmentNamePrefix.trim() : tableName;
        this._appendPushType = "APPEND".equalsIgnoreCase(pushType);
        this._excludeSequenceId = Boolean.parseBoolean(excludeSequenceId);
        if (this._appendPushType) {
            this._outputSDF = "HOURLY".equalsIgnoreCase(pushFrequency) ? new SimpleDateFormat("yyyy-MM-dd-HH") : new SimpleDateFormat("yyyy-MM-dd");
            this._outputSDF.setTimeZone(TimeZone.getTimeZone("UTC"));
            if (Preconditions.checkNotNull(timeFormat).equals(TimeGranularitySpec.TimeFormat.EPOCH.toString())) {
                this._inputTimeUnit = TimeUnit.valueOf(timeType);
                this._inputSDF = null;
            } else {
                Preconditions.checkArgument(timeFormat.startsWith(TimeGranularitySpec.TimeFormat.SIMPLE_DATE_FORMAT.toString()), "Invalid time format: %s, must be one of '%s' or '%s:<pattern>'", (Object)timeFormat, (Object)TimeGranularitySpec.TimeFormat.EPOCH, (Object)TimeGranularitySpec.TimeFormat.SIMPLE_DATE_FORMAT);
                this._inputTimeUnit = null;
                this._inputSDF = new SimpleDateFormat(timeFormat.substring(timeFormat.indexOf(58) + 1));
                this._inputSDF.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
        } else {
            this._outputSDF = null;
            this._inputTimeUnit = null;
            this._inputSDF = null;
        }
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        Integer sequenceIdInSegmentName;
        Integer n = sequenceIdInSegmentName = !this._excludeSequenceId && sequenceId >= 0 ? Integer.valueOf(sequenceId) : null;
        if (!this._appendPushType) {
            return JOINER.join(this._segmentNamePrefix, sequenceIdInSegmentName, new Object[0]);
        }
        return JOINER.join(this._segmentNamePrefix, this.getNormalizedDate(Preconditions.checkNotNull(minTimeValue)), this.getNormalizedDate(Preconditions.checkNotNull(maxTimeValue)), sequenceIdInSegmentName);
    }

    private String getNormalizedDate(Object timeValue) {
        if (this._inputTimeUnit != null) {
            return this._outputSDF.format(new Date(this._inputTimeUnit.toMillis(Long.parseLong(timeValue.toString()))));
        }
        try {
            return this._outputSDF.format(this._inputSDF.parse(timeValue.toString()));
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Caught exception while parsing simple date format: %s with value: %s", this._inputSDF.toPattern(), timeValue), e);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NormalizedDateSegmentNameGenerator: segmentNamePrefix=").append(this._segmentNamePrefix).append(", appendPushType=").append(this._appendPushType);
        if (this._excludeSequenceId) {
            stringBuilder.append(", excludeSequenceId=true");
        }
        if (this._outputSDF != null) {
            stringBuilder.append(", outputSDF=").append(this._outputSDF.toPattern());
        }
        if (this._inputTimeUnit != null) {
            stringBuilder.append(", inputTimeUnit=").append((Object)this._inputTimeUnit);
        }
        if (this._inputSDF != null) {
            stringBuilder.append(", inputSDF=").append(this._inputSDF.toPattern());
        }
        return stringBuilder.toString();
    }
}

