/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.store;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.indexsegment.generator.SegmentVersion;

public class SegmentDirectoryPaths {
    public static final String V3_SUBDIRECTORY_NAME = "v3";

    private SegmentDirectoryPaths() {
    }

    @Nonnull
    public static File segmentDirectoryFor(@Nonnull File indexDir, @Nonnull SegmentVersion segmentVersion) {
        switch (segmentVersion) {
            case v1: 
            case v2: {
                return indexDir;
            }
            case v3: {
                return new File(indexDir, V3_SUBDIRECTORY_NAME);
            }
        }
        throw new UnsupportedOperationException("Unsupported segment version: " + (Object)((Object)segmentVersion) + " while trying to get segment directory from: " + indexDir);
    }

    @Nonnull
    public static File findSegmentDirectory(@Nonnull File indexDir) {
        Preconditions.checkArgument(indexDir.isDirectory(), "Path: %s is not a directory", (Object)indexDir);
        File v3SegmentDir = SegmentDirectoryPaths.segmentDirectoryFor(indexDir, SegmentVersion.v3);
        if (v3SegmentDir.isDirectory()) {
            return v3SegmentDir;
        }
        return indexDir;
    }

    public static boolean isV3Directory(@Nonnull File path) {
        return path.toString().endsWith(V3_SUBDIRECTORY_NAME);
    }

    @Nullable
    public static File findMetadataFile(@Nonnull File indexDir) {
        return SegmentDirectoryPaths.findFormatFile(indexDir, "metadata.properties");
    }

    @Nullable
    public static File findCreationMetaFile(@Nonnull File indexDir) {
        return SegmentDirectoryPaths.findFormatFile(indexDir, "creation.meta");
    }

    @Nullable
    public static File findStarTreeFile(@Nonnull File indexDir) {
        return SegmentDirectoryPaths.findFormatFile(indexDir, "star-tree.bin");
    }

    @Nullable
    private static File findFormatFile(@Nonnull File indexDir, @Nonnull String fileName) {
        Preconditions.checkArgument(indexDir.isDirectory(), "Path: %s is not a directory", (Object)indexDir);
        File v3Dir = SegmentDirectoryPaths.segmentDirectoryFor(indexDir, SegmentVersion.v3);
        File v3File = new File(v3Dir, fileName);
        if (v3File.exists()) {
            return v3File;
        }
        File v1File = new File(indexDir, fileName);
        if (v1File.exists()) {
            return v1File;
        }
        return null;
    }
}

