/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn;

import java.io.IOException;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.BaseSingleColumnSingleValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.DataFileReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.SortedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.reader.impl.v1.SortedIndexReaderImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.DictionaryDelegatingValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.io.util.ValueReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.readers.StringDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.BaseVirtualColumnProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.IntSingleValueDataFileReader;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.Pairs;

public abstract class SingleStringVirtualColumnProvider
extends BaseVirtualColumnProvider {
    protected abstract String getValue(VirtualColumnContext var1);

    @Override
    public DataFileReader buildReader(VirtualColumnContext context) {
        return new IntSingleValueDataFileReader(0);
    }

    @Override
    public Dictionary buildDictionary(VirtualColumnContext context) {
        DictionaryDelegatingValueReader valueReader = new DictionaryDelegatingValueReader();
        SingleStringDictionary stringDictionary = new SingleStringDictionary(valueReader, context.getTotalDocCount(), context);
        valueReader.setDictionary(stringDictionary);
        return stringDictionary;
    }

    @Override
    public ColumnMetadata buildMetadata(VirtualColumnContext context) {
        ColumnMetadata.Builder columnMetadataBuilder = super.getColumnMetadataBuilder(context);
        columnMetadataBuilder.setCardinality(1).setHasDictionary(true).setHasInvertedIndex(true).setFieldType(FieldSpec.FieldType.DIMENSION).setDataType(FieldSpec.DataType.STRING).setSingleValue(true).setIsSorted(true);
        return columnMetadataBuilder.build();
    }

    @Override
    public InvertedIndexReader buildInvertedIndex(VirtualColumnContext context) {
        return new SingleStringInvertedIndex(context.getTotalDocCount());
    }

    private class SingleStringDictionary
    extends StringDictionary {
        private int _length;
        private VirtualColumnContext _context;

        public SingleStringDictionary(ValueReader valueReader, int length, VirtualColumnContext context) {
            super(valueReader, length);
            this._length = length;
            this._context = context;
        }

        @Override
        public int getIntValue(int dictId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLongValue(int dictId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getFloatValue(int dictId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getDoubleValue(int dictId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int length() {
            return this._length;
        }

        @Override
        public boolean isSorted() {
            return true;
        }

        @Override
        public int indexOf(Object rawValue) {
            if (rawValue.equals(SingleStringVirtualColumnProvider.this.getValue(this._context))) {
                return 0;
            }
            return -1;
        }

        @Override
        public String get(int dictId) {
            return SingleStringVirtualColumnProvider.this.getValue(this._context);
        }

        @Override
        public String getStringValue(int dictId) {
            return SingleStringVirtualColumnProvider.this.getValue(this._context);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class SingleStringInvertedIndex
    extends BaseSingleColumnSingleValueReader<SortedIndexReaderImpl.Context>
    implements SortedIndexReader<SortedIndexReaderImpl.Context> {
        private int _length;

        public SingleStringInvertedIndex(int length) {
            this._length = length;
        }

        @Override
        public Pairs.IntPair getDocIds(int dictId) {
            if (dictId == 0) {
                return new Pairs.IntPair(0, this._length);
            }
            return new Pairs.IntPair(-1, -1);
        }

        @Override
        public int getInt(int row) {
            return 0;
        }

        @Override
        public int getInt(int rowId, SortedIndexReaderImpl.Context context) {
            return 0;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public SortedIndexReaderImpl.Context createContext() {
            return null;
        }
    }
}

