/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn;

import org.apache.pinot.;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.DocIdVirtualColumnProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.SegmentNameVirtualColumnProvider;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.common.data.DimensionFieldSpec;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.Schema;

public class VirtualColumnProviderFactory {
    public static VirtualColumnProvider buildProvider(String virtualColumnProvider) {
        try {
            Class<?> providerClass = Class.forName(virtualColumnProvider);
            return (VirtualColumnProvider)providerClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public static void addBuiltInVirtualColumnsToSchema(Schema schema) {
        if (!schema.hasColumn("$docId")) {
            schema.addField(new DimensionFieldSpec("$docId", FieldSpec.DataType.INT, true, DocIdVirtualColumnProvider.class));
        }
        if (!schema.hasColumn("$hostName")) {
            schema.addField(new DimensionFieldSpec("$hostName", FieldSpec.DataType.STRING, true, .HostNameVirtualColumnProvider.class));
        }
        if (!schema.hasColumn("$segmentName")) {
            schema.addField(new DimensionFieldSpec("$segmentName", FieldSpec.DataType.STRING, true, SegmentNameVirtualColumnProvider.class));
        }
    }
}

