/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pinot.$internal.org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.common.utils.Pairs;

public class StarTreeDataTable
implements Closeable {
    private final PinotDataBuffer _dataBuffer;
    private final int _dimensionSize;
    private final int _metricSize;
    private final int _docSize;
    private final long _docSizeLong;
    private final int _startDocId;

    public StarTreeDataTable(PinotDataBuffer dataBuffer, int dimensionSize, int metricSize, int startDocId) {
        Preconditions.checkState(dataBuffer.size() > 0L);
        this._dataBuffer = dataBuffer;
        this._dimensionSize = dimensionSize;
        this._metricSize = metricSize;
        this._docSize = dimensionSize + metricSize;
        this._docSizeLong = this._docSize;
        this._startDocId = startDocId;
    }

    public void sort(int startDocId, int endDocId, final int[] sortOrder) {
        Preconditions.checkState(startDocId < endDocId);
        int numDocs = endDocId - startDocId;
        int startDocIdOffset = startDocId - this._startDocId;
        final int[] sortedDocIds = new int[numDocs];
        for (int i2 = 0; i2 < numDocs; ++i2) {
            sortedDocIds[i2] = i2 + startDocIdOffset;
        }
        IntComparator comparator = new IntComparator(){

            public int compare(int i1, int i2) {
                long offset1 = (long)sortedDocIds[i1] * StarTreeDataTable.this._docSizeLong;
                long offset2 = (long)sortedDocIds[i2] * StarTreeDataTable.this._docSizeLong;
                for (int index : sortOrder) {
                    int v2;
                    int v1 = StarTreeDataTable.this._dataBuffer.getInt(offset1 + (long)(index * 4));
                    if (v1 == (v2 = StarTreeDataTable.this._dataBuffer.getInt(offset2 + (long)(index * 4)))) continue;
                    return v1 - v2;
                }
                return 0;
            }

            public int compare(Integer o1, Integer o2) {
                throw new UnsupportedOperationException();
            }
        };
        Swapper swapper = (i, j) -> {
            int temp = sortedDocIds[i];
            nArray[i] = sortedDocIds[j];
            nArray[j] = temp;
        };
        Arrays.quickSort((int)0, (int)numDocs, (IntComparator)comparator, (Swapper)swapper);
        byte[] buffer = new byte[this._docSize];
        for (int i3 = 0; i3 < numDocs; ++i3) {
            int currentDocId;
            int properDocId;
            int actualDocId = i3 + startDocIdOffset;
            if (actualDocId == sortedDocIds[i3]) continue;
            this._dataBuffer.copyTo((long)actualDocId * this._docSizeLong, buffer, 0, this._docSize);
            int currentIndex = i3;
            while (actualDocId != (properDocId = sortedDocIds[currentIndex])) {
                currentDocId = currentIndex + startDocIdOffset;
                this._dataBuffer.copyTo((long)properDocId * this._docSizeLong, this._dataBuffer, (long)currentDocId * this._docSizeLong, this._docSizeLong);
                sortedDocIds[currentIndex] = currentDocId;
                currentIndex = properDocId - startDocIdOffset;
            }
            currentDocId = currentIndex + startDocIdOffset;
            this._dataBuffer.readFrom((long)currentDocId * this._docSizeLong, buffer, 0, this._docSize);
            sortedDocIds[currentIndex] = currentDocId;
        }
    }

    public Int2ObjectMap<Pairs.IntPair> groupOnDimension(int startDocId, int endDocId, int dimensionId) {
        Preconditions.checkState(startDocId < endDocId);
        int startDocIdOffset = startDocId - this._startDocId;
        int endDocIdOffset = endDocId - this._startDocId;
        Int2ObjectLinkedOpenHashMap rangeMap = new Int2ObjectLinkedOpenHashMap();
        int dimensionOffset = dimensionId * 4;
        int currentValue = this._dataBuffer.getInt((long)startDocIdOffset * this._docSizeLong + (long)dimensionOffset);
        int groupStartDocId = startDocId;
        for (int i = startDocIdOffset + 1; i < endDocIdOffset; ++i) {
            int value = this._dataBuffer.getInt((long)i * this._docSizeLong + (long)dimensionOffset);
            if (value == currentValue) continue;
            int groupEndDocId = i + this._startDocId;
            rangeMap.put(currentValue, (Object)new Pairs.IntPair(groupStartDocId, groupEndDocId));
            currentValue = value;
            groupStartDocId = groupEndDocId;
        }
        rangeMap.put(currentValue, (Object)new Pairs.IntPair(groupStartDocId, endDocId));
        return rangeMap;
    }

    public Iterator<Pair<byte[], byte[]>> iterator(int startDocId, int endDocId) {
        Preconditions.checkState(startDocId < endDocId);
        final int startDocIdOffset = startDocId - this._startDocId;
        final int endDocIdOffset = endDocId - this._startDocId;
        return new Iterator<Pair<byte[], byte[]>>(){
            private int _currentIndex;
            {
                this._currentIndex = startDocIdOffset;
            }

            @Override
            public boolean hasNext() {
                return this._currentIndex < endDocIdOffset;
            }

            @Override
            public Pair<byte[], byte[]> next() {
                byte[] dimensionBytes = new byte[StarTreeDataTable.this._dimensionSize];
                byte[] metricBytes = new byte[StarTreeDataTable.this._metricSize];
                long dimensionOffset = (long)this._currentIndex++ * StarTreeDataTable.this._docSizeLong;
                StarTreeDataTable.this._dataBuffer.copyTo(dimensionOffset, dimensionBytes, 0, StarTreeDataTable.this._dimensionSize);
                StarTreeDataTable.this._dataBuffer.copyTo(dimensionOffset + (long)StarTreeDataTable.this._dimensionSize, metricBytes, 0, StarTreeDataTable.this._metricSize);
                return new ImmutablePair<byte[], byte[]>(dimensionBytes, metricBytes);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setDimensionValue(int dimensionId, int value) {
        int numDocs = (int)(this._dataBuffer.size() / this._docSizeLong);
        for (int i = 0; i < numDocs; ++i) {
            this._dataBuffer.putInt((long)i * this._docSizeLong + (long)(dimensionId * 4), value);
        }
    }

    @Override
    public void close() throws IOException {
        this._dataBuffer.close();
    }
}

