/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.AggregationFunctionContext;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2Metadata;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.request.FilterQueryTree;

public class StarTreeUtils {
    public static final String USE_STAR_TREE_KEY = "useStarTree";

    private StarTreeUtils() {
    }

    public static boolean isStarTreeDisabled(@Nonnull BrokerRequest brokerRequest) {
        Map<String, String> debugOptions = brokerRequest.getDebugOptions();
        return debugOptions != null && "false".equalsIgnoreCase(debugOptions.get(USE_STAR_TREE_KEY));
    }

    public static boolean isFitForStarTree(@Nonnull StarTreeV2Metadata starTreeV2Metadata, @Nonnull Set<AggregationFunctionColumnPair> aggregationFunctionColumnPairs, @Nullable Set<TransformExpressionTree> groupByExpressions, @Nullable FilterQueryTree rootFilterNode) {
        for (AggregationFunctionColumnPair aggregationFunctionColumnPair : aggregationFunctionColumnPairs) {
            if (starTreeV2Metadata.containsFunctionColumnPair(aggregationFunctionColumnPair)) continue;
            return false;
        }
        HashSet<String> starTreeDimensions = new HashSet<String>(starTreeV2Metadata.getDimensionsSplitOrder());
        if (groupByExpressions != null) {
            HashSet<String> groupByColumns = new HashSet<String>();
            for (TransformExpressionTree groupByExpression : groupByExpressions) {
                groupByExpression.getColumns(groupByColumns);
            }
            if (!starTreeDimensions.containsAll(groupByColumns)) {
                return false;
            }
        }
        return rootFilterNode == null || StarTreeUtils.checkFilters(rootFilterNode, starTreeDimensions);
    }

    private static boolean checkFilters(@Nonnull FilterQueryTree filterNode, @Nonnull Set<String> starTreeDimensions) {
        FilterOperator operator = filterNode.getOperator();
        if (operator == FilterOperator.OR) {
            return false;
        }
        if (operator == FilterOperator.AND) {
            for (FilterQueryTree child : filterNode.getChildren()) {
                if (StarTreeUtils.checkFilters(child, starTreeDimensions)) continue;
                return false;
            }
            return true;
        }
        String column = filterNode.getColumn();
        return starTreeDimensions.contains(column);
    }

    public static AggregationFunctionContext createStarTreeFunctionContext(@Nonnull AggregationFunctionContext functionContext) {
        AggregationFunction function = functionContext.getAggregationFunction();
        AggregationFunctionColumnPair functionColumnPair = new AggregationFunctionColumnPair(function.getType(), functionContext.getColumn());
        return new AggregationFunctionContext(function, functionColumnPair.toColumnName());
    }

    public static AggregationFunctionContext[] createStarTreeFunctionContexts(@Nonnull AggregationFunctionContext[] functionContexts) {
        int numContexts = functionContexts.length;
        AggregationFunctionContext[] starTreeFunctionContexts = new AggregationFunctionContext[numContexts];
        for (int i = 0; i < numContexts; ++i) {
            starTreeFunctionContexts[i] = StarTreeUtils.createStarTreeFunctionContext(functionContexts[i]);
        }
        return starTreeFunctionContexts;
    }
}

