/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.hll;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.common.Utils;

public class HllUtil {
    public static String inspectGenericRow(GenericRow row, String hllDeriveColumnSuffix) {
        StringBuilder b = new StringBuilder();
        for (String name : row.getFieldNames()) {
            b.append(name);
            b.append(" : ");
            Object value = row.getValue(name);
            if (value instanceof String && name.endsWith(hllDeriveColumnSuffix)) {
                b.append(HllUtil.convertStringToHll((String)value).cardinality());
            } else if (value instanceof Object[]) {
                b.append(Arrays.toString((Object[])value));
            } else {
                b.append(value);
            }
            b.append(", ");
        }
        return b.toString();
    }

    public static byte[] toBytes(HyperLogLog hll) {
        try {
            return hll.getBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertHllToString(HyperLogLog hll) {
        return new String(SerializationConverter.byteArrayToChars(HllUtil.toBytes(hll)));
    }

    public static HyperLogLog convertStringToHll(String s) {
        return HllUtil.buildHllFromBytes(SerializationConverter.charsToByteArray(s.toCharArray()));
    }

    public static String singleValueHllAsString(int log2m, Object value) {
        HyperLogLog hll = new HyperLogLog(log2m);
        hll.offer(value);
        return HllUtil.convertHllToString(hll);
    }

    public static HyperLogLog buildHllFromBytes(byte[] bytes) {
        try {
            return HyperLogLog.Builder.build((byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HyperLogLog clone(HyperLogLog hll, int log2m) {
        try {
            HyperLogLog ret = new HyperLogLog(log2m);
            ret.addAll(hll);
            return ret;
        }
        catch (CardinalityMergeException e) {
            throw new RuntimeException(e);
        }
    }

    public static HyperLogLog mergeHLLResultsToFirstInList(List<HyperLogLog> resultList) {
        HyperLogLog hllResult = resultList.get(0);
        for (int i = 1; i < resultList.size(); ++i) {
            try {
                hllResult.addAll(resultList.get(i));
                continue;
            }
            catch (CardinalityMergeException e) {
                Utils.rethrowException(e);
            }
        }
        return hllResult;
    }

    public static class SerializationConverter {
        private static final int BYTE_TO_CHAR_OFFSET = 129;

        public static char[] byteArrayToChars(byte[] byteArray) {
            char[] charArrayBuffer = new char[byteArray.length];
            for (int i = 0; i < byteArray.length; ++i) {
                charArrayBuffer[i] = SerializationConverter.byteToChar(byteArray[i]);
            }
            return charArrayBuffer;
        }

        public static byte[] charsToByteArray(char[] chars) {
            byte[] ret = new byte[chars.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = SerializationConverter.charToByte(chars[i]);
            }
            return ret;
        }

        public static char byteToChar(byte b) {
            return (char)(b + 129);
        }

        public static byte charToByte(char c) {
            return (byte)(c - 129);
        }
    }
}

