/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.plan;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.operator.StarTreeFilterOperator;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarTreeFilterPlanNode
implements PlanNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(StarTreeFilterPlanNode.class);
    private final StarTreeV2 _starTreeV2;
    private final FilterQueryTree _rootFilterNode;
    private final Set<String> _groupByColumns;
    private final Map<String, String> _debugOptions;

    public StarTreeFilterPlanNode(StarTreeV2 starTreeV2, @Nullable FilterQueryTree rootFilterNode, @Nullable Set<String> groupByColumns, @Nullable Map<String, String> debugOptions) {
        this._starTreeV2 = starTreeV2;
        this._rootFilterNode = rootFilterNode;
        this._groupByColumns = groupByColumns;
        this._debugOptions = debugOptions;
    }

    @Override
    public StarTreeFilterOperator run() {
        return new StarTreeFilterOperator(this._starTreeV2, this._rootFilterNode, this._groupByColumns, this._debugOptions);
    }

    @Override
    public void showTree(String prefix) {
        LOGGER.debug(prefix + "StarTree Filter Plan Node:");
        LOGGER.debug(prefix + "Operator: StarTreeFilterOperator");
        LOGGER.debug(prefix + "Argument 0: Filters - " + this._rootFilterNode);
        LOGGER.debug(prefix + "Argument 1: Group-by Columns - " + this._groupByColumns);
    }
}

